
# Foreword

This Informational Specification covers a proposal to add factory automation support to Redfish.

IMPORTANT: These documents are not final.  They do not necessarily reflect the views of the DMTF or its members.  Because these documents are a Work in Progress, these documents may still change, perhaps profoundly and without notice.  These documents are available for public review and comment until superseded.

The following files are part of the Redfish for Factory Automation development effort:

`Mockup` folder containing a mockup of a JobDocument-based implemenation with AutomationNode examples

`Metadata` folder containing new or updated Redfish schema files.  The contents of these schema files are detailed in the Schema Reference Guide section of this document.

`Redfish for Factory Automation.PDF` - Presentation describing the enhancements to the JobService and the additions of AutomationNode data models.

## How can I provide feedback?

Feedback on all Redfish specifications and documents is encouraged.  Feedback can be directed to the DMTF and the Redfish Forum by the following means:

* **Redfish User Forum:**  <a href="https://redfishforum.com">https://redfishforum.com</a> - User forum monitored by DMTF Redfish Forum personnel to answer questions about any Redfish-related topics.
* **DMTF Feedback Portal:**  <a href="https://www.dmtf.org/standards/feedback">https://www.dmtf.org/standards/feedback</a> - Formal submission portal for enhancements or proposals to the DMTF and Redfish Forum.
* **Redfish Github Repository:**  DMTF Redfish Forum member companies are encouraged to open issues on the group's private repository on Github.

## Where can I find more information?

The following web sites provide more information about the Redfish standard:

* **Redfish Developer Hub:**  <a href="http://redfish.dmtf.org">http://redfish.dmtf.org</a> - Resources for developers building applications using Redfish.  Contains an interactive schema explorer, hosted schema and other links.
* **Redfish User Forum:**  <a href="https://redfishforum.com">https://redfishforum.com</a> - User forum monitored by DMTF Redfish personnel to answer questions about any Redfish-related topics.
* **DMTF Github Repositories:**  <a href="http://www.github.com/DMTF">http://www.github.com/DMTF</a> - Open source tools and libraries for working with the Redfish API.
* **Redfish Standards:**  <a href="https://www.dmtf.org/standards/redfish">https://www.dmtf.org/standards/redfish</a> - Schemas, specs, mockups, white papers, FAQ, educational material and more.
* **DMTF Redfish Forum** (Working group that maintains the Redfish standard):  <a href="http://www.dmtf.org/standards/spmf">http://www.dmtf.org/standards/spmf</a> - Companies involved, upcoming schedules and future work, charter, and information about joining.

## Using the reference guide

The proposed schemas are listed in the following section for reference.  This section should be considered an extension to the contents of DSP2046, the Redfish Resource and Schema Guide, which lists the common Redfish properties, other object definitions, and all released Redfish schemas (including those shown here).

This guide was produced using the contents of the schema files from DMTF Redfish Schema bundle DSP8010 and merged with supplemental text using the DMTF's [Redfish Documentation Generator](#redfish-documentation-generator).

## Common Properties

Properties and objects defined for all Redfish schemas, or referenced by this white paper are detailed in the Redfish Resource and Schema Guide (DSP2046), available for download at the Redfish Standards site: <a href="https://www.dmtf.org/standards/redfish">https://www.dmtf.org/standards/redfish</a>


# Schema Reference Guide



## AutomationInstrumentation 1.0.0

|     |     |
| :--- | :--- |
| **Version** | *v1.0* |
| **Release** | 2024.2 |

### Description

Parameters for AutomationInstrumentation.

### URIs

/&#8203;redfish/&#8203;v1/&#8203;AutomationNodes/&#8203;*{AutomationNodeId}*/&#8203;AutomationInstrumentation<br>


### Properties

|Property     |Type     |Attributes   |Notes     |
| :--- | :--- | :--- | :--------------------- |
| **AccelerationGain** { | object<br>(excerpt) |  | An acceleration gain control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **AccelerationMpS2** { | object<br>(excerpt) |  | An acceleration control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **CurrentAmps** { | object<br>(excerpt) |  | The current (A) for this node. This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**CrestFactor** *(v1.1+)* | number | *read-only<br>(null)* | The crest factor for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**THDPercent** *(v1.1+)* | number<br>(%) | *read-only<br>(null)* | The total harmonic distortion percent (% THD). |
| } |   |   |
| **NodeState** | string<br>(enum) | *read-only* | The current state of the node. *For the possible property values, see NodeState in Property details.* |
| **PID** { | object<br>(excerpt) |  | A PID control loop. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlLoop** { | object |  | The control loop details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**CoefficientUpdateTime** | string<br>(date-time) | *read-only<br>(null)* | The date and time that the control loop coefficients were changed. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Differential** | number | *read-write<br>(null)* | The differential coefficient. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Integral** | number | *read-write<br>(null)* | The integral coefficient. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Proportional** | number | *read-write<br>(null)* | The proportional coefficient. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **PositionMeters** { | object<br>(excerpt) |  | A position control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **Status** {} | object |  | The status and health of a resource and its children. See the *Resource* schema for details on this property. |
| **TemperatureCelsius** { | object<br>(excerpt) |  | Temperature (Celsius). This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| } |   |   |
| **VelocityMpS** { | object<br>(excerpt) |  | A velocity control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **Voltage** { | object<br>(excerpt) |  | The voltage (V) for this node. This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**CrestFactor** *(v1.1+)* | number | *read-only<br>(null)* | The crest factor for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**THDPercent** *(v1.1+)* | number<br>(%) | *read-only<br>(null)* | The total harmonic distortion percent (% THD). |
| } |   |   |
| **XAccelerationGain** { | object<br>(excerpt) |  | A X-axis acceleration gain control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **XAccelerationMpS2** { | object<br>(excerpt) |  | A X-axis acceleration control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **XPositionMeters** { | object<br>(excerpt) |  | A X-axis position control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **XVelocityMpS** { | object<br>(excerpt) |  | A X-axis velocity control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **YAccelerationGain** { | object<br>(excerpt) |  | A Y-axis acceleration gain control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **YAccelerationMpS2** { | object<br>(excerpt) |  | A Y-axis acceleration control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **YPositionMeters** { | object<br>(excerpt) |  | A Y-axis position control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **YVelocityMpS** { | object<br>(excerpt) |  | A Y-axis velocity control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **ZAccelerationGain** { | object<br>(excerpt) |  | A Z-axis acceleration gain control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **ZAccelerationMpS2** { | object<br>(excerpt) |  | A Z-axis acceleration control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **ZPositionMeters** { | object<br>(excerpt) |  | A Z-axis position control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **ZVelocityMpS** { | object<br>(excerpt) |  | A Z-axis velocity control. This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |

### Property details

#### ControlMode

The current operating mode of the control.

| string | Description |
| :--- | :------------ |
| Automatic | Automatically adjust control to meet the set point. |
| Disabled | The control has been disabled. |
| Manual | No automatic adjustments are made to the control. |
| Override | User override of the automatic set point value. |

#### NodeState

The current state of the node.

| string | Description |
| :--- | :------------ |
| ConditionStop | The resource's controller has stopped due to a condition fault. |
| Done | The resource's controller has reached its destination position. |
| ErrorStop | The resource's controller has stopped due to an error. |
| Idle | The resource's controller is idle. |
| Running | The resource's controller is running. |
| Waiting | The resource's controller is waiting to start. |

### Example response


```json
{
    "@odata.type": "#AutomationInstrumentation.v1_0_0.AutomationInstrumentation",
    "Id": "Instrumentation",
    "Name": "Instrumentation for X-Axis Motion Controller",
    "Status": {
        "State": "Enabled",
        "Health": "OK",
        "Conditions": []
    },
    "NodeState": "Running",
    "PositionMeters": {
        "DataSourceUri": "/redfish/v1/Chassis/Node1/Controls/XOutput",
        "SetPoint": 0.75,
        "PendingSetPoint": 0.93,
        "Reading": 0.51
    },
    "VelocityMpS": {
        "DataSourceUri": "/redfish/v1/Chassis/Node1/Controls/XVelocity",
        "Reading": 0.02
    },
    "AccelerationMpS2": {
        "Reading": 0.0
    },
    "Voltage": {
        "DataSourceUri": "/redfish/v1/Chassis/Node1/Sensors/Voltage",
        "Reading": 24.3
    },
    "TemperatureCelsius": {
        "DataSourceUri": "/redfish/v1/Chassis/Node1/Sensors/Temperature",
        "Reading": 39.8
    },  
    "@odata.id": "/redfish/v1/AutomationNodes/XAxisMover/AutomationInstrumentation"
}
```



## AutomationNode 1.0.0

|     |     |
| :--- | :--- |
| **Version** | *v1.0* |
| **Release** | 2024.2 |

### Description

Parameters for AutomationNode.

### URIs

/&#8203;redfish/&#8203;v1/&#8203;AutomationNodes/&#8203;*{AutomationNodeId}*<br>


### Properties

|Property     |Type     |Attributes   |Notes     |
| :--- | :--- | :--- | :--------------------- |
| **AssertInterlock** | boolean | *read-write* | The value of the global interlock signal requested by this resource. |
| **Instrumentation** { | object |  | A link to the instrumentation resource for this node. See the *AutomationInstrumentation* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a AutomationInstrumentation resource. See the Links section and the *AutomationInstrumentation* schema for details. |
| } |   |   |
| **Links** { | object |  | The links to other resources that are related to this resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AutomationNodeGroup** [ { | array |  | An array of links to the automation nodes that are included in an automation node group. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to another AutomationNode resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AutomationNodeGroup@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Chassis** [ { | array |  | An array of links to the chassis that contain this equipment. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a Chassis resource. See the Links section and the *Chassis* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Chassis@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Oem** {} | object |  | The OEM extension property. See the *Resource* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**OutputControl** { | object |  | A link to OutputControl. See the *Control* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a Control resource. See the Links section and the *Control* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PidFeedbackSensor** { | object |  | A link to PidFeedbackSensor. See the *Sensor* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a Sensor resource. See the Links section and the *Sensor* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PositionSensor** { | object |  | A link to PositionSensor. See the *Sensor* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a Sensor resource. See the Links section and the *Sensor* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**VelocitySensor** { | object |  | A link to VelocitySensor. See the *Sensor* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a Sensor resource. See the Links section and the *Sensor* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| } |   |   |
| **MotionAxis** | string<br>(enum) | *read-write<br>(null)* | The primary axis of motion for this motion-related node. *For the possible property values, see MotionAxis in Property details.* |
| **MotionProfile** | string<br>(enum) | *read-write<br>(null)* | The motion profile type used for this node. *For the possible property values, see MotionProfile in Property details.* |
| **NodeState** | string<br>(enum) | *read-only* | The current state of the node. *For the possible property values, see NodeState in Property details.* |
| **NodeType** | string<br>(enum) | *read-only* | The type of this automation node. *For the possible property values, see NodeType in Property details.* |
| **Status** {} | object |  | The status and health of a resource and its children. See the *Resource* schema for details on this property. |

### Actions

#### Reset


**Description**


Reset the node.


**Action URI**



*{Base URI of target resource}*/Actions/AutomationNode.Reset


**Action parameters**


This action takes no parameters.


#### SendTrigger


**Description**


The trigger action for the resource.


**Action URI**



*{Base URI of target resource}*/Actions/AutomationNode.SendTrigger


**Action parameters**


This action takes no parameters.


#### Start


**Description**


The start action for the resource.


**Action URI**



*{Base URI of target resource}*/Actions/AutomationNode.Start


**Action parameters**


This action takes no parameters.


#### Stop


**Description**


The stop action for the resource.


**Action URI**



*{Base URI of target resource}*/Actions/AutomationNode.Stop


**Action parameters**


This action takes no parameters.


#### Wait


**Description**


The wait action for the resource.


**Action URI**



*{Base URI of target resource}*/Actions/AutomationNode.Wait


**Action parameters**


This action takes no parameters.


### Property details

#### MotionAxis

The primary axis of motion for this motion-related node.

| string | Description |
| :--- | :------------ |
| ThreeAxis | 3-axis. |
| TwoAxis | 2-axis. |
| X | X axis. |
| Y | Y axis. |
| Z | Z axis. |

#### MotionProfile

The motion profile type used for this node.

| string | Description |
| :--- | :------------ |
| None | No profile specified. |
| SCurve | S-curve profile. |
| Trapezoidal | Trapezoidal profile. |

#### NodeState

The current state of the node.

| string | Description |
| :--- | :------------ |
| ConditionStop | The resource's controller has stopped due to a condition fault. |
| Done | The resource's controller has reached its destination position. |
| ErrorStop | The resource's controller has stopped due to an error. |
| Idle | The resource's controller is idle. |
| Running | The resource's controller is running. |
| Waiting | The resource's controller is waiting to start. |

#### NodeType

The type of this automation node.

| string | Description |
| :--- | :------------ |
| MotionPosition | This value specifies that the AutomationNode supports position-based profiled motion where position, velocity and acceleration are all controlled. |
| MotionPositionGroup | This value specifies that the AutomationNode supports a multi-axis position-based profiled motion where position, velocity and acceleration are all controlled. |
| MotionVelocity | This value specifies that the AutomationNode supports velocity-based profiled motion where position, velocity and acceleration are all controlled. |
| PID | This value specifies that the Automation node attempts to match a setpoint using a PID control algorithm. |
| Simple | This value specifies that the Automation node is a simple resource that incorporates no automated control function. |

### Example response


```json
{
    "@odata.type": "#AutomationNode.v1_0_0.AutomationNode",
    "Id": "XAxisMover",
    "Name": "X-Axis positioner",
    "Description": "The X axis automation node for the machine.",
    "Status": {
        "State": "Enabled",
        "Health": "OK",
        "Conditions": []
    },
    "AssertInterlock": false,
    "NodeState": "Running",
    "NodeType": "MotionPosition",
    "MotionProfile": "Trapezoidal",
    "MotionAxis": "X",
    "Instrumentation": {
        "@odata.id": "/redfish/v1/AutomationNodes/XAxisMover/AutomationInstrumentation"
    },
    "Links": {
        "Chassis": [
            {
                "@odata.id": "/redfish/v1/Chassis/3AxisMotion"
            }
        ]
    },
    "Actions": {
        "#AutomationNode.Reset": {
            "target": "/redfish/v1/AutomationNodes/XAxisMover/Actions/AutomationNode.Reset"
        },
        "#AutomationNode.SendTrigger": {
            "target": "/redfish/v1/AutomationNodes/XAxisMover/Actions/AutomationNode.SendTrigger"
        },
        "#AutomationNode.Start": {
            "target": "/redfish/v1/AutomationNodes/XAxisMover/Actions/AutomationNode.Start"
        },
        "#AutomationNode.Stop": {
            "target": "/redfish/v1/AutomationNodes/XAxisMover/Actions/AutomationNode.Stop"
        },
        "#AutomationNode.Wait": {
            "target": "/redfish/v1/AutomationNodes/XAxisMover/Actions/AutomationNode.Wait"
        }
    },
    "@odata.id": "/redfish/v1/AutomationNodes/XAxisMover"
}
```



## Chassis 1.26.0

|     |     |     |     |     |     |     |     |     |     |     |     |     |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| **Version** | *v1.26* | *v1.25* | *v1.24* | *v1.23* | *v1.22* | *v1.21* | *v1.20* | *v1.19* | *v1.18* | *v1.17* | *v1.16* | *...* |
| **Release** | 2024.2 | 2023.3 | 2023.2 | 2023.1 | 2022.3 | 2022.2 | 2022.1 | 2021.4 | 2021.3 | 2021.2 | 2021.1 | ... |

### Description

The `Chassis` schema represents the physical components of a system.  This resource represents the sheet-metal confined spaces and logical zones such as racks, enclosures, chassis and all other containers.  Subsystems, such as sensors, that operate outside of a system's data plane are linked either directly or indirectly through this resource.  A subsystem that operates outside of a system's data plane are not accessible to software that runs on the system.  It also describes the location, such as a slot, socket, or bay, where a unit can be installed, by populating a resource instance with an absent state if a unit is not present.

### URIs

/&#8203;redfish/&#8203;v1/&#8203;Chassis/&#8203;*{ChassisId}*<br>


### Properties

|Property     |Type     |Attributes   |Notes     |
| :--- | :--- | :--- | :--------------------- |
| **Assembly** *(v1.6+)* {} | object |  | The link to the assembly associated with this chassis. See the *Assembly* schema for details on this property. |
| **AssetTag** | string | *read-write<br>(null)* | The user-assigned asset tag of this chassis. |
| **Certificates** *(v1.15+)* { | object |  | The link to a collection of certificates for device identity and attestation. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Certificate*. See the Certificate schema for details. |
| } |   |   |
| **ChassisType** | string<br>(enum) | *read-only required* | The type of physical form factor of the chassis. *For the possible property values, see ChassisType in Property details.* |
| **Controls** *(v1.17+)* { | object |  | The link to the collection of controls located in this chassis. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Control*. See the Control schema for details. |
| } |   |   |
| **DepthMm** *(v1.4+)* | number<br>(mm) | *read-only<br>(null)* | The depth of the chassis. |
| **Doors** *(v1.24+)* { | object |  | The doors or access panels of the chassis. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Front** *(v1.24+)* { | object | *<br>(null)* | The front door of the chassis. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DoorState** *(v1.24+)* | string<br>(enum) | *read-only<br>(null)* | The state of the door. *For the possible property values, see DoorState in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Locked** *(v1.24+)* | boolean | *read-write<br>(null)* | Indicates if the door is locked. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**UserLabel** *(v1.24+)* | string | *read-write* | A user-assigned label. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Rear** *(v1.24+)* { | object | *<br>(null)* | The rear door of the chassis. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DoorState** *(v1.24+)* | string<br>(enum) | *read-only<br>(null)* | The state of the door. *For the possible property values, see DoorState in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Locked** *(v1.24+)* | boolean | *read-write<br>(null)* | Indicates if the door is locked. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**UserLabel** *(v1.24+)* | string | *read-write* | A user-assigned label. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| } |   |   |
| **Drives** *(v1.14+)* { | object |  | The link to the collection of drives within this chassis. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Drive*. See the Drive schema for details. |
| } |   |   |
| **ElectricalSourceManagerURIs** *(v1.18+)* [ ] | array<br>(URI) (string, null) | *read-write* | The URIs of the management interfaces for the external electrical source connections for this chassis. |
| **ElectricalSourceNames** *(v1.18+)* [ ] | array (string, null) | *read-write* | The names of the external electrical sources, such as circuits or outlets, connected to this chassis. |
| **EnvironmentalClass** *(v1.9+)* | string<br>(enum) | *read-write<br>(null)* | The ASHRAE Environmental Class for this chassis. *For the possible property values, see EnvironmentalClass in Property details.* |
| **EnvironmentMetrics** *(v1.15+)* { | object |  | The link to the environment metrics for this chassis. See the *EnvironmentMetrics* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a EnvironmentMetrics resource. See the Links section and the *EnvironmentMetrics* schema for details. |
| } |   |   |
| **FabricAdapters** *(v1.20+)* { | object |  | The link to the collection of fabric adapters located in this chassis that provide access to fabric-related resource pools. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *FabricAdapter*. See the FabricAdapter schema for details. |
| } |   |   |
| **HeatingCoolingEquipmentNames** *(v1.25+)* [ ] | array (string, null) | *read-write* | The names of the external heating or cooling equipment, such as coolant distribution units, connected to this chassis. |
| **HeatingCoolingManagerURIs** *(v1.25+)* [ ] | array<br>(URI) (string, null) | *read-write* | The URIs of the management interfaces for the external heating or cooling equipment for this chassis. |
| **HeightMm** *(v1.4+)* | number<br>(mm) | *read-only<br>(null)* | The height of the chassis. |
| **HotPluggable** *(v1.21+)* | boolean | *read-only<br>(null)* | An indication of whether this component can be inserted or removed while the equipment is in operation. |
| **IndicatorLED** *(deprecated v1.14)* | string<br>(enum) | *read-write<br>(null)* | The state of the indicator LED, which identifies the chassis. *For the possible property values, see IndicatorLED in Property details.* *Deprecated in v1.14 and later. This property has been deprecated in favor of the `LocationIndicatorActive` property.* |
| **Links** { | object |  | The links to other resources that are related to this resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AutomationNodes** *(v1.26+)* [ { | array |  | An array of links to the automation nodes contained in this chassis. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a AutomationNode resource. See the Links section and the *AutomationNode* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AutomationNodes@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Cables** *(v1.17+)* [ { } ] | array (object) |  | An array of links to the cables connected to this chassis. See the *Cable* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Cables@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ComputerSystems** [ { } ] | array (object) |  | An array of links to the computer systems that this chassis directly and wholly contains. See the *ComputerSystem* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ComputerSystems@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ConnectedCoolingLoops** *(v1.23+)* [ { } ] | array (object) |  | An array of links to cooling loops connected to this chassis. See the *CoolingLoop* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ConnectedCoolingLoops@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ContainedBy** { | object |  | The link to the chassis that contains this chassis. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-write* | Link to another Chassis resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Contains** [ { | array |  | An array of links to any other chassis that this chassis has in it. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-write* | Link to another Chassis resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Contains@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**CooledBy** *(deprecated v1.20)* [ { | array |  | An array of links to resources or objects that cool this chassis.  Normally, the link is for either a chassis or a specific set of fans. *Deprecated in v1.20 and later. This property has been deprecated in favor of the `Fans` link property, and details provided in the `ThermalSubsystem` resource.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string<br>(URI) | *read-only* | The unique identifier for a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**CooledBy@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**CoolingUnits** *(v1.23+)* [ { } ] | array (object) |  | An array of links to cooling unit functionality contained in this chassis. See the *CoolingUnit* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**CoolingUnits@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Drives** *(v1.2+)* [ { } ] | array (object) |  | An array of links to the drives located in this chassis. See the *Drive* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Drives@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Facility** *(v1.11+)* {} | object |  | The link to the facility that contains this chassis. See the *Facility* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Fans** *(v1.20+)* [ { } ] | array (object) |  | An array of links to the fans that cool this chassis. See the *Fan* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Fans@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ManagedBy** [ { } ] | array (object) |  | An array of links to the managers responsible for managing this chassis. See the *Manager* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ManagedBy@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ManagersInChassis** *(v1.2+)* [ { } ] | array (object) |  | An array of links to the managers located in this chassis. See the *Manager* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ManagersInChassis@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Oem** {} | object |  | The OEM extension property. See the *Resource* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PCIeDevices** *(v1.4+, deprecated v1.10)* [ { } ] | array (object) |  | An array of links to the PCIe devices located in this chassis. See the *PCIeDevice* schema for details on this property. *Deprecated in v1.10 and later. This property has been deprecated in favor of the `PCIeDevices` resource collection in the root of this resource.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PCIeDevices@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PowerDistribution** *(v1.20+)* {} | object | *<br>(null)* | A link to power distribution functionality contained in this chassis. See the *PowerDistribution* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PowerOutlets** *(v1.18+)* [ { } ] | array (object) |  | An array of links to the outlets that provide power to this chassis. See the *Outlet* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PowerOutlets@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PowerSupplies** *(v1.20+)* [ { } ] | array (object) |  | An array of links to the power supplies that provide power to this chassis. See the *PowerSupply* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PowerSupplies@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PoweredBy** *(deprecated v1.20)* [ { | array |  | An array of links to resources or objects that power this chassis.  Normally, the link is for either a chassis or a specific set of power supplies. *Deprecated in v1.20 and later. This property has been deprecated in favor of the `PowerOutlets` and `PowerSupplies` link properties, and details provided in the `PowerSubsystem` resource.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string<br>(URI) | *read-only* | The unique identifier for a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PoweredBy@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Processors** *(v1.9+)* [ { } ] | array (object) |  | An array of links to the processors located in this chassis. See the *Processor* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Processors@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ResourceBlocks** *(v1.5+)* [ { } ] | array (object) |  | An array of links to the resource blocks located in this chassis. See the *ResourceBlock* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ResourceBlocks@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Storage** *(v1.2+)* [ { } ] | array (object) |  | An array of links to the storage subsystems connected to or inside this chassis. See the *Storage* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Storage@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Switches** *(v1.7+)* [ { } ] | array (object) |  | An array of links to the switches located in this chassis. See the *Switch* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Switches@odata.count** | integer | *read-only* | The number of items in a collection. |
| } |   |   |
| **Location** *(v1.2+)* {} | object |  | The location of the chassis. See the *Resource* schema for details on this property. |
| **LocationIndicatorActive** *(v1.14+)* | boolean | *read-write<br>(null)* | An indicator allowing an operator to physically locate this resource. |
| **LogServices** { | object |  | The link to the logs for this chassis. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *LogService*. See the LogService schema for details. |
| } |   |   |
| **Manufacturer** | string | *read-only<br>(null)* | The manufacturer of this chassis. |
| **MaxPowerWatts** *(v1.12+)* | number<br>(Watts) | *read-only<br>(null)* | The upper bound of the total power consumed by the chassis. |
| **Measurements** *(v1.15+, deprecated v1.19)* [ { } ] | array (object) |  | An array of DSP0274-defined measurement blocks. See the *SoftwareInventory* schema for details on this property. *Deprecated in v1.19 and later. This property has been deprecated in favor of the `ComponentIntegrity` resource.* |
| **MediaControllers** *(v1.11+, deprecated v1.20)* { | object |  | The link to the collection of media controllers located in this chassis. Contains a link to a resource. *Deprecated in v1.20 and later. This property has been deprecated in favor of `FabricAdapters`.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *MediaController*. See the MediaController schema for details. |
| } |   |   |
| **Memory** *(v1.11+)* { | object |  | The link to the collection of memory located in this chassis that belong to fabric-related resource pools. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Memory*. See the Memory schema for details. |
| } |   |   |
| **MemoryDomains** *(v1.11+)* { | object |  | The link to the collection of memory domains located in this chassis that belong to fabric-related resource pools. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *MemoryDomain*. See the MemoryDomain schema for details. |
| } |   |   |
| **MinPowerWatts** *(v1.12+)* | number<br>(Watts) | *read-only<br>(null)* | The lower bound of the total power consumed by the chassis. |
| **Model** | string | *read-only<br>(null)* | The model number of the chassis. |
| **NetworkAdapters** *(v1.4+)* { | object |  | The link to the collection of network adapters associated with this chassis. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *NetworkAdapter*. See the NetworkAdapter schema for details. |
| } |   |   |
| **PartNumber** | string | *read-only<br>(null)* | The part number of the chassis. |
| **PCIeDevices** *(v1.10+)* { | object |  | The link to the collection of PCIe devices located in this chassis. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *PCIeDevice*. See the PCIeDevice schema for details. |
| } |   |   |
| **PCIeSlots** *(v1.8+, deprecated v1.24)* {} | object |  | The link to the PCIe slot properties for this chassis. See the *PCIeSlots* schema for details on this property. *Deprecated in v1.24 and later. This property has been deprecated in favor of the `PCIeDevices` property.  The `PCIeSlots` schema has been deprecated in favor of the `PCIeDevice` schema.  Empty PCIe slots are represented by `PCIeDevice` resources using the `Absent` value of the `State` property within `Status`.* |
| **PhysicalSecurity** *(v1.1+)* { | object |  | The physical security state of the chassis. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**IntrusionSensor** *(v1.1+)* | string<br>(enum) | *read-write<br>(null)* | The physical security state of the chassis, such as if hardware intrusion is detected. *For the possible property values, see IntrusionSensor in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**IntrusionSensorNumber** *(v1.1+, deprecated v1.22)* | integer | *read-only<br>(null)* | A numerical identifier to represent the physical security sensor. *Deprecated in v1.22 and later. This property has been deprecated in order to allow for multiple physical sensors to construct this object.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**IntrusionSensorReArm** *(v1.1+)* | string<br>(enum) | *read-write<br>(null)* | The policy that describes how the physical security state of the chassis returns to a normal state. *For the possible property values, see IntrusionSensorReArm in Property details.* |
| } |   |   |
| **Power** *(deprecated v1.15)* {} | object |  | The link to the power properties, or power supplies, power policies, and sensors, for this chassis. See the *Power* schema for details on this property. *Deprecated in v1.15 and later. This link has been deprecated in favor of the `PowerSubsystem` link property.* |
| **PoweredByParent** *(v1.20+)* | boolean | *read-only<br>(null)* | Indicates that the chassis receives power from the containing chassis. |
| **PowerState** *(v1.0.1+)* | string<br>(enum) | *read-only<br>(null)* | The current power state of the chassis. *For the possible property values, see PowerState in Property details.* |
| **PowerSubsystem** *(v1.15+)* {} | object |  | The link to the power subsystem properties for this chassis. See the *PowerSubsystem* schema for details on this property. |
| **Processors** *(v1.22+)* { | object |  | The link to the collection of processors located in this chassis that belong to fabric-related resource pools. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Processor*. See the Processor schema for details. |
| } |   |   |
| **Replaceable** *(v1.21+)* | boolean | *read-only<br>(null)* | An indication of whether this component can be independently replaced as allowed by the vendor's replacement policy. |
| **Sensors** *(v1.9+)* { | object |  | The link to the collection of sensors located in the equipment and sub-components. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Sensor*. See the Sensor schema for details. |
| } |   |   |
| **SerialNumber** | string | *read-only<br>(null)* | The serial number of the chassis. |
| **SKU** | string | *read-only<br>(null)* | The SKU of the chassis. |
| **SparePartNumber** *(v1.16+)* | string | *read-only<br>(null)* | The spare part number of the chassis. |
| **Status** {} | object |  | The status and health of the resource and its subordinate or dependent resources. See the *Resource* schema for details on this property. |
| **Thermal** *(deprecated v1.15)* {} | object |  | The link to the thermal properties, such as fans, cooling, and sensors, for this chassis. See the *Thermal* schema for details on this property. *Deprecated in v1.15 and later. This link has been deprecated in favor of the `ThermalSubsystem` link property.* |
| **ThermalDirection** *(v1.20+)* | string<br>(enum) | *read-only<br>(null)* | Indicates the thermal management path through the chassis. *For the possible property values, see ThermalDirection in Property details.* |
| **ThermalManagedByParent** *(v1.20+)* | boolean | *read-only<br>(null)* | Indicates that the chassis is thermally managed by the parent chassis. |
| **ThermalSubsystem** *(v1.15+)* {} | object |  | The link to the thermal subsystem properties for this chassis. See the *ThermalSubsystem* schema for details on this property. |
| **TrustedComponents** *(v1.21+)* { | object |  | The link to the trusted components in this chassis. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *TrustedComponent*. See the TrustedComponent schema for details. |
| } |   |   |
| **UUID** *(v1.7+)* | string<br>(uuid) | *read-only<br>(null)* | The UUID for this chassis. |
| **Version** *(v1.21+)* | string | *read-only<br>(null)* | The hardware version of this chassis. |
| **WeightKg** *(v1.4+)* | number<br>(kg) | *read-only<br>(null)* | The weight of the chassis. |
| **WidthMm** *(v1.4+)* | number<br>(mm) | *read-only<br>(null)* | The width of the chassis. |

### Actions

#### Reset


**Description**


This action resets the chassis.  Additionally, it could reset systems or other contained resources depending on the `ResetType` used to invoke this action.


**Action URI**



*{Base URI of target resource}*/Actions/Chassis.Reset


**Action parameters**

| Parameter Name     | Type     | Attributes   | Notes     |
| :--- | :--- | :--- | :--------------------- |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ResetType** | string<br>(enum) | *optional* | The type of reset. *For the possible property values, see ResetType in Property details.* |

**Request Example**

```json
{
    "ResetType": "ForceRestart"
}
```



### Property details

#### ChassisType

The type of physical form factor of the chassis.

| string | Description |
| :--- | :------------ |
| Blade | An enclosed or semi-enclosed, typically vertically-oriented, system chassis that must be plugged into a multi-system chassis to function normally. |
| Card | A loose device or circuit board intended to be installed in a system or other enclosure. |
| Cartridge | A small self-contained system intended to be plugged into a multi-system chassis. |
| Component | A small chassis, card, or device that contains devices for a particular subsystem or function. |
| Drawer | An enclosed or semi-enclosed, typically horizontally-oriented, system chassis that can be slid into a multi-system chassis. |
| Enclosure | A generic term for a chassis that does not fit any other description. |
| Expansion | A chassis that expands the capabilities or capacity of another chassis. |
| HeatExchanger *(v1.23+)* | A heat exchanger. |
| ImmersionTank *(v1.23+)* | An immersion cooling tank. |
| IPBasedDrive *(v1.3+)* | A chassis in a drive form factor with IP-based network connections. |
| Module | A small, typically removable, chassis or card that contains devices for a particular subsystem or function. |
| Other | A chassis that does not fit any of these definitions. |
| Pod | A collection of equipment racks in a large, likely transportable, container. |
| PowerStrip *(v1.25+)* | A power strip, typically placed in the zero-U space of a rack. |
| Rack | An equipment rack, typically a 19-inch wide freestanding unit. |
| RackGroup *(v1.4+)* | A group of racks that form a single entity or share infrastructure. |
| RackMount | A single-system chassis designed specifically for mounting in an equipment rack. |
| Row | A collection of equipment racks. |
| Shelf | An enclosed or semi-enclosed, typically horizontally-oriented, system chassis that must be plugged into a multi-system chassis to function normally. |
| Sidecar | A chassis that mates mechanically with another chassis to expand its capabilities or capacity. |
| Sled | An enclosed or semi-enclosed, system chassis that must be plugged into a multi-system chassis to function normally similar to a blade type chassis. |
| StandAlone | A single, free-standing system, commonly called a tower or desktop chassis. |
| StorageEnclosure *(v1.6+)* | A chassis that encloses storage. |
| Zone | A logical division or portion of a physical chassis that contains multiple devices or systems that cannot be physically separated. |

#### DoorState

The state of the door.

| string | Description |
| :--- | :------------ |
| Closed | Door is closed. |
| Locked | Door is closed and locked. |
| LockedAndOpen | Door is open and locked. |
| Open | Door is open. |

#### EnvironmentalClass

The ASHRAE Environmental Class for this chassis.

| string | Description |
| :--- | :------------ |
| A1 | ASHRAE Environmental Class 'A1'. |
| A2 | ASHRAE Environmental Class 'A2'. |
| A3 | ASHRAE Environmental Class 'A3'. |
| A4 | ASHRAE Environmental Class 'A4'. |

#### IndicatorLED

The state of the indicator LED, which identifies the chassis.

| string | Description |
| :--- | :------------ |
| Blinking | The indicator LED is blinking. |
| Lit | The indicator LED is lit. |
| Off | The indicator LED is off. |
| Unknown *(deprecated v1.2)* | The state of the indicator LED cannot be determined. *Deprecated in v1.2 and later. This value has been deprecated in favor of returning `null` if the state is unknown.* |

#### IntrusionSensor

The physical security state of the chassis, such as if hardware intrusion is detected.

| string | Description |
| :--- | :------------ |
| HardwareIntrusion | A door, lock, or other mechanism protecting the internal system hardware from being accessed is detected to be in an insecure state. |
| Normal | No physical security condition is detected at this time. |
| TamperingDetected | Physical tampering of the monitored entity is detected. |

#### IntrusionSensorReArm

The policy that describes how the physical security state of the chassis returns to a normal state.

| string | Description |
| :--- | :------------ |
| Automatic | The sensor is automatically restored to the normal state when no security condition is detected. |
| Manual | A user is required to clear the sensor to restore it to the normal state. |

#### PowerState

The current power state of the chassis.

| string | Description |
| :--- | :------------ |
| Off | The resource is powered off.  The components within the resource might continue to have AUX power. |
| On | The resource is powered on. |
| Paused | The resource is paused. |
| PoweringOff | A temporary state between on and off.  The components within the resource can take time to process the power off action. |
| PoweringOn | A temporary state between off and on.  The components within the resource can take time to process the power on action. |

#### ResetType

The type of reset.

| string | Description |
| :--- | :------------ |
| ForceOff | Turn off the unit immediately (non-graceful shutdown). |
| ForceOn | Turn on the unit immediately. |
| ForceRestart | Shut down immediately and non-gracefully and restart the unit. |
| GracefulRestart | Shut down gracefully and restart the unit. |
| GracefulShutdown | Shut down gracefully and power off. |
| Nmi | Generate a diagnostic interrupt, which is usually an NMI on x86 systems, to stop normal operations, complete diagnostic actions, and, typically, halt the system. |
| On | Turn on the unit. |
| Pause | Pause execution on the unit but do not remove power.  This is typically a feature of virtual machine hypervisors. |
| PowerCycle | Power cycle the unit.  Behaves like a full power removal, followed by a power restore to the resource. |
| PushPowerButton | Simulate the pressing of the physical power button on this unit. |
| Resume | Resume execution on the paused unit.  This is typically a feature of virtual machine hypervisors. |
| Suspend | Write the state of the unit to disk before powering off.  This allows for the state to be restored when powered back on. |

#### ThermalDirection

Indicates the thermal management path through the chassis.

| string | Description |
| :--- | :------------ |
| BackToFront | A chassis with the air intake in the back and exhaust out the front. |
| FrontToBack | A chassis with the air intake in the front and exhaust out the back. |
| Sealed | A sealed chassis with no air pathway. |
| TopExhaust | A chassis with air exhaust on the top. |

### Example response


```json
{
    "@odata.type": "#Chassis.v1_25_1.Chassis",
    "Id": "1U",
    "Name": "Computer System Chassis",
    "ChassisType": "RackMount",
    "AssetTag": "Chicago-45Z-2381",
    "Manufacturer": "Contoso",
    "Model": "3500RX",
    "SKU": "8675309",
    "SerialNumber": "437XR1138R2",
    "PartNumber": "224071-J23",
    "PowerState": "On",
    "LocationIndicatorActive": true,
    "Location": {
        "Placement": {
            "Row": "North",
            "Rack": "WEB43",
            "RackOffsetUnits": "EIA_310",
            "RackOffset": 12
        }
    },
    "Status": {
        "State": "Enabled",
        "Health": "OK"
    },
    "HeightMm": 44.45,
    "WidthMm": 431.8,
    "DepthMm": 711,
    "WeightKg": 15.31,
    "EnvironmentalClass": "A3",
    "Sensors": {
        "@odata.id": "/redfish/v1/Chassis/1U/Sensors"
    },
    "PowerSubsystem": {
        "@odata.id": "/redfish/v1/Chassis/1U/PowerSubsystem"
    },
    "ThermalSubsystem": {
        "@odata.id": "/redfish/v1/Chassis/1U/ThermalSubsystem"
    },
    "EnvironmentMetrics": {
        "@odata.id": "/redfish/v1/Chassis/1U/EnvironmentMetrics"
    },
    "Links": {
        "ComputerSystems": [
            {
                "@odata.id": "/redfish/v1/Systems/437XR1138R2"
            }
        ],
        "ManagedBy": [
            {
                "@odata.id": "/redfish/v1/Managers/BMC"
            }
        ],
        "ManagersInChassis": [
            {
                "@odata.id": "/redfish/v1/Managers/BMC"
            }
        ]
    },
    "@odata.id": "/redfish/v1/Chassis/1U"
}
```



## Control 1.6.0

|     |     |     |     |     |     |     |     |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| **Version** | *v1.6* | *v1.5* | *v1.4* | *v1.3* | *v1.2* | *v1.1* | *v1.0* |
| **Release** | 2024.2 | 2023.3 | 2023.2 | 2023.1 | 2022.2 | 2021.4 | 2021.2 |

### Description

The `Control` schema describes a control point and its properties.

### URIs

/&#8203;redfish/&#8203;v1/&#8203;Chassis/&#8203;*{ChassisId}*/&#8203;Controls/&#8203;*{ControlId}*<br>


### Properties

|Property     |Type     |Attributes   |Notes     |
| :--- | :--- | :--- | :--------------------- |
| **Accuracy** *(deprecated v1.4)* | number<br>(%) | *read-only<br>(null)* | The estimated percent error of measured versus actual values. *Deprecated in v1.4 and later. This property has been deprecated in favor of `SetPointAccuracy` to provide a range instead of a percentage.* |
| **AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| **AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| **AllowableNumericValues** [ ] | array (number, null) | *read-only* | The supported values for the set point. |
| **AssociatedSensors** [ { | array |  | An array of links to the sensors associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a Sensor resource. See the Links section and the *Sensor* schema for details. |
| } ] |   |   |
| **ControlDelaySeconds** | number | *read-write<br>(null)* | The time delay in seconds before the control will activate once the value has deviated from the set point. |
| **ControlLoop** { | object |  | The control loop details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**CoefficientUpdateTime** | string<br>(date-time) | *read-only<br>(null)* | The date and time that the control loop coefficients were changed. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Differential** | number | *read-write<br>(null)* | The differential coefficient. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Integral** | number | *read-write<br>(null)* | The integral coefficient. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Proportional** | number | *read-write<br>(null)* | The proportional coefficient. |
| } |   |   |
| **ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| **ControlType** | string<br>(enum) | *read-only<br>(null)* | The type of control. *For the possible property values, see ControlType in Property details.* |
| **DeadBand** | number | *read-write<br>(null)* | The maximum deviation from the set point allowed before the control will activate. |
| **DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| **Implementation** | string<br>(enum) | *read-only<br>(null)* | The implementation of the control. *For the possible property values, see Implementation in Property details.* |
| **Increment** | number | *read-only<br>(null)* | The smallest increment supported for the set point. |
| **Location** {} | object |  | The location information for this control. See the *Resource* schema for details on this property. |
| **PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| **PhysicalContext** | string<br>(enum) | *read-only<br>(null)* | The area or device to which this control applies. *For the possible property values, see PhysicalContext in Property details.* |
| **PhysicalSubContext** | string<br>(enum) | *read-only<br>(null)* | The usage or location within a device to which this control applies. *For the possible property values, see PhysicalSubContext in Property details.* |
| **RelatedItem** [ { | array |  | An array of links to resources that this control services. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string<br>(URI) | *read-only* | The unique identifier for a resource. |
| } ] |   |   |
| **Sensor** { | object<br>(excerpt) |  | The sensor reading associated with this control. This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| } |   |   |
| **SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| **SetPointAccuracy** *(v1.4+)* | number | *read-only<br>(null)* | Accuracy (+/-) of the set point. |
| **SetPointError** *(v1.6+)* | number | *read-only<br>(null)* | The error (difference) from the desired set point of the control. |
| **SetPointType** | string<br>(enum) | *read-only<br>(null)* | The set point type used to operate the control. *For the possible property values, see SetPointType in Property details.* |
| **SetPointUnits** | string | *read-only<br>(null)* | The units of the set point. |
| **SetPointUpdateTime** | string<br>(date-time) | *read-only<br>(null)* | The date and time that the set point was changed. |
| **SettingMax** | number | *read-write<br>(null)* | The maximum set point in the allowed range. |
| **SettingMin** | number | *read-write<br>(null)* | The minimum set point in the allowed range. |
| **Status** {} | object |  | The status and health of the resource and its subordinate or dependent resources. See the *Resource* schema for details on this property. |

### Actions

#### ResetToDefaults *(v1.2+)*


**Description**


The action resets the values of writable properties to factory defaults.


**Action URI**



*{Base URI of target resource}*/Actions/Control.ResetToDefaults


**Action parameters**


This action takes no parameters.


### Property details

#### ControlMode

The current operating mode of the control.

| string | Description |
| :--- | :------------ |
| Automatic | Automatically adjust control to meet the set point. |
| Disabled | The control has been disabled. |
| Manual | No automatic adjustments are made to the control. |
| Override | User override of the automatic set point value. |

#### ControlType

The type of control.

| string | Description |
| :--- | :------------ |
| DutyCycle *(v1.5+)* | Duty cycle (%) control. |
| Frequency | Frequency (Hz) control. |
| FrequencyMHz *(v1.1+)* | Frequency (MHz) control. |
| LinearAcceleration *(v1.6+)* | Linear acceleration (m/s^2) control. |
| LinearPosition *(v1.6+)* | Linear position or distance (m) control. |
| LinearVelocity *(v1.6+)* | Linear velocity (m/s) control. |
| Percent *(v1.5+)* | Percent-based control. |
| Power | Power (W) control or power limit. |
| Pressure *(v1.1+, deprecated v1.3)* | Pressure (kPa) control. *Deprecated in v1.3 and later. This value has been deprecated in favor of `PressurekPa` for units consistency with the equivalent `Sensor` resource `ReadingType` value.* |
| PressurekPa *(v1.3+)* | Pressure (kPa) control. |
| RotationalAcceleration *(v1.6+)* | Rotational acceleration (rad/s^2) control. |
| RotationalPosition *(v1.6+)* | Rotational position (rad) control. |
| RotationalVelocity *(v1.6+)* | Rotational velocity (rad/s) control. |
| Temperature | Temperature (C) control or thermostat. |
| Valve *(v1.3+)* | Valve (% open) control. |

#### Implementation

The implementation of the control.

| string | Description |
| :--- | :------------ |
| Direct | The set point directly affects the control value. |
| Monitored | A physical control that cannot be adjusted through this interface. |
| Programmable | The set point can be adjusted through this interface. |

#### PhysicalContext

The area or device to which this control applies.

| string | Description |
| :--- | :------------ |
| Accelerator | An accelerator. |
| ACInput | An AC input. |
| ACMaintenanceBypassInput | An AC maintenance bypass input. |
| ACOutput | An AC output. |
| ACStaticBypassInput | An AC static bypass input. |
| ACUtilityInput | An AC utility input. |
| ASIC | An ASIC device, such as a networking chip or chipset component. |
| Back | The back of the chassis. |
| Backplane | A backplane within the chassis. |
| Battery | A battery. |
| Board | A circuit board. |
| Chassis | The entire chassis. |
| ComputeBay | Within a compute bay. |
| CoolingSubsystem | The entire cooling, or air and liquid, subsystem. |
| CPU | A processor (CPU). |
| CPUSubsystem | The entire processor (CPU) subsystem. |
| DCBus | A DC bus. |
| Exhaust | The air exhaust point or points or region of the chassis. |
| ExpansionBay | Within an expansion bay. |
| Fan | A fan. |
| Filter | A filter. |
| FPGA | An FPGA. |
| Front | The front of the chassis. |
| GPU | A graphics processor (GPU). |
| GPUSubsystem | The entire graphics processor (GPU) subsystem. |
| Intake | The air intake point or points or region of the chassis. |
| LiquidInlet | The liquid inlet point of the chassis. |
| LiquidOutlet | The liquid outlet point of the chassis. |
| Lower | The lower portion of the chassis. |
| Manager | A management controller, such as a BMC (baseboard management controller). |
| Memory | A memory device. |
| MemorySubsystem | The entire memory subsystem. |
| Motor | A motor. |
| NetworkBay | Within a networking bay. |
| NetworkingDevice | A networking device. |
| PowerSubsystem | The entire power subsystem. |
| PowerSupply | A power supply. |
| PowerSupplyBay | Within a power supply bay. |
| Pump | A pump. |
| Rectifier | A rectifier device. |
| Reservoir | A reservoir. |
| Room | The room. |
| StorageBay | Within a storage bay. |
| StorageDevice | A storage device. |
| Switch | A switch device. |
| SystemBoard | The system board (PCB). |
| Transceiver | A transceiver. |
| Transformer | A transformer. |
| TrustedModule | A trusted module. |
| Upper | The upper portion of the chassis. |
| VoltageRegulator | A voltage regulator device. |

#### PhysicalSubContext

The usage or location within a device to which this control applies.

| string | Description |
| :--- | :------------ |
| Input | The input. |
| Output | The output. |

#### SetPointType

The set point type used to operate the control.

| string | Description |
| :--- | :------------ |
| Monitor *(v1.6+)* | Control only monitors a reading. |
| Range | Control uses a range of values. |
| Single | Control uses a single set point. |

### Example response


```json
{
    "@odata.type": "#Control.v1_5_1.Control",
    "Id": "PowerLimit",
    "Name": "System Power Limit",
    "PhysicalContext": "Chassis",
    "ControlType": "Power",
    "ControlMode": "Automatic",
    "SetPoint": 500,
    "SetPointUnits": "W",
    "AllowableMax": 1000,
    "AllowableMin": 150,
    "Sensor": {
        "Reading": 374,
        "DataSourceUri": "/redfish/v1/Chassis/1U/Sensors/TotalPower"
    },
    "Status": {
        "Health": "OK",
        "State": "Enabled"
    },
    "@odata.id": "/redfish/v1/Chassis/1U/Controls/PowerLimit"
}
```



## EnvironmentMetrics 1.4.0

|     |     |     |     |     |     |
| :--- | :--- | :--- | :--- | :--- | :--- |
| **Version** | *v1.4* | *v1.3* | *v1.2* | *v1.1* | *v1.0* |
| **Release** | 2024.2 | 2022.2 | 2021.4 | 2021.2 | 2020.4 |

### Description

The `EnvironmentMetrics` schema represents the environmental metrics of a device.

### URIs

/&#8203;redfish/&#8203;v1/&#8203;Chassis/&#8203;*{ChassisId}*/&#8203;Drives/&#8203;*{DriveId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Chassis/&#8203;*{ChassisId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Chassis/&#8203;*{ChassisId}*/&#8203;FabricAdapters/&#8203;*{FabricAdapterId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Chassis/&#8203;*{ChassisId}*/&#8203;MediaControllers/&#8203;*{MediaControllerId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Chassis/&#8203;*{ChassisId}*/&#8203;MediaControllers/&#8203;*{MediaControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Chassis/&#8203;*{ChassisId}*/&#8203;Memory/&#8203;*{MemoryId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Chassis/&#8203;*{ChassisId}*/&#8203;NetworkAdapters/&#8203;*{NetworkAdapterId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Chassis/&#8203;*{ChassisId}*/&#8203;NetworkAdapters/&#8203;*{NetworkAdapterId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Chassis/&#8203;*{ChassisId}*/&#8203;PCIeDevices/&#8203;*{PCIeDeviceId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Drives/&#8203;*{DriveId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Memory/&#8203;*{MemoryId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Processors/&#8203;*{ProcessorId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Processors/&#8203;*{ProcessorId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Controllers/&#8203;*{ControllerId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Controllers/&#8203;*{StorageControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Drives/&#8203;*{DriveId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;StorageControllers/&#8203;*{StorageControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;FabricAdapters/&#8203;*{FabricAdapterId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;GraphicsControllers/&#8203;*{ControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Memory/&#8203;*{MemoryId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;PCIeDevices/&#8203;*{PCIeDeviceId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Processors/&#8203;*{ProcessorId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Processors/&#8203;*{ProcessorId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Controllers/&#8203;*{ControllerId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Controllers/&#8203;*{StorageControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Drives/&#8203;*{DriveId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;StorageControllers/&#8203;*{StorageControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;CompositionService/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;USBControllers/&#8203;*{ControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Fabrics/&#8203;*{FabricId}*/&#8203;Switches/&#8203;*{SwitchId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Fabrics/&#8203;*{FabricId}*/&#8203;Switches/&#8203;*{SwitchId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Facilities/&#8203;*{FacilityId}*/&#8203;AmbientMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Facilities/&#8203;*{FacilityId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Managers/&#8203;*{ManagerId}*/&#8203;DedicatedNetworkPorts/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Managers/&#8203;*{ManagerId}*/&#8203;USBPorts/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Drives/&#8203;*{DriveId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Memory/&#8203;*{MemoryId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Processors/&#8203;*{ProcessorId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Processors/&#8203;*{ProcessorId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Controllers/&#8203;*{ControllerId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Controllers/&#8203;*{StorageControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Drives/&#8203;*{DriveId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;StorageControllers/&#8203;*{StorageControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;FabricAdapters/&#8203;*{FabricAdapterId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;GraphicsControllers/&#8203;*{ControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Memory/&#8203;*{MemoryId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;PCIeDevices/&#8203;*{PCIeDeviceId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Processors/&#8203;*{ProcessorId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Processors/&#8203;*{ProcessorId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Controllers/&#8203;*{ControllerId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Controllers/&#8203;*{StorageControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Drives/&#8203;*{DriveId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;StorageControllers/&#8203;*{StorageControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ResourceBlocks/&#8203;*{ResourceBlockId}*/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;USBControllers/&#8203;*{ControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Controllers/&#8203;*{ControllerId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Controllers/&#8203;*{StorageControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Storage/&#8203;*{StorageId}*/&#8203;StorageControllers/&#8203;*{StorageControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;FabricAdapters/&#8203;*{FabricAdapterId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;GraphicsControllers/&#8203;*{ControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Memory/&#8203;*{MemoryId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;PCIeDevices/&#8203;*{PCIeDeviceId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Processors/&#8203;*{ProcessorId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Processors/&#8203;*{ProcessorId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Controllers/&#8203;*{ControllerId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Controllers/&#8203;*{StorageControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;Drives/&#8203;*{DriveId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;Storage/&#8203;*{StorageId}*/&#8203;StorageControllers/&#8203;*{StorageControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;Systems/&#8203;*{ComputerSystemId}*/&#8203;USBControllers/&#8203;*{ControllerId}*/&#8203;Ports/&#8203;*{PortId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ThermalEquipment/&#8203;CDUs/&#8203;*{CoolingUnitId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ThermalEquipment/&#8203;HeatExchangers/&#8203;*{CoolingUnitId}*/&#8203;EnvironmentMetrics<br>
/&#8203;redfish/&#8203;v1/&#8203;ThermalEquipment/&#8203;ImmersionUnits/&#8203;*{CoolingUnitId}*/&#8203;EnvironmentMetrics<br>


### Properties

|Property     |Type     |Attributes   |Notes     |
| :--- | :--- | :--- | :--------------------- |
| **AbsoluteHumidity** *(v1.2+)* { | object<br>(excerpt) |  | Absolute humidity (g/m^3). This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| } |   |   |
| **CurrentAmps** *(v1.4+)* { | object<br>(excerpt) |  | The current (A) for this device. This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**CrestFactor** *(v1.1+)* | number | *read-only<br>(null)* | The crest factor for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**THDPercent** *(v1.1+)* | number<br>(%) | *read-only<br>(null)* | The total harmonic distortion percent (% THD). |
| } |   |   |
| **DewPointCelsius** *(v1.1+)* { | object<br>(excerpt) |  | The dew point temperature (C). This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| } |   |   |
| **EnergyJoules** *(v1.2+)* { | object<br>(excerpt) |  | Energy consumption (J). This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| } |   |   |
| **EnergykWh** { | object<br>(excerpt) |  | Energy consumption (kWh). This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ApparentkVAh** *(v1.5+)* | number<br>(kV.A.h) | *read-only<br>(null)* | Apparent energy (kVAh). |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**LifetimeReading** *(v1.1+)* | number | *read-only<br>(null)* | The total accumulation value for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReactivekVARh** *(v1.5+)* | number<br>(kV.A.h) | *read-only<br>(null)* | Reactive energy (kVARh). |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SensorResetTime** | string<br>(date-time) | *read-only<br>(null)* | The date and time when the time-based properties were last reset. |
| } |   |   |
| **FanSpeedsPercent** [ { | array<br>(excerpt) |  | Fan speeds (percent). This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DeviceName** *(v1.2+)* | string | *read-only<br>(null)* | The name of the device. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PhysicalContext** | string<br>(enum) | *read-write<br>(null)* | The area or device to which this sensor measurement applies. *For the possible property values, see PhysicalContext in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PhysicalSubContext** | string<br>(enum) | *read-write<br>(null)* | The usage or location within a device to which this sensor measurement applies. *For the possible property values, see PhysicalSubContext in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SpeedRPM** *(v1.2+)* | number<br>({rev}/min) | *read-only<br>(null)* | The rotational speed. |
| } ] |   |   |
| **HumidityPercent** { | object<br>(excerpt) |  | Humidity (percent). This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| } |   |   |
| **PowerLimitWatts** *(v1.1+)* { | object<br>(excerpt) |  | Power limit (W). This object is an excerpt of the *Control* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMax** | number | *read-only<br>(null)* | The maximum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableMin** | number | *read-only<br>(null)* | The minimum possible setting for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ControlMode** | string<br>(enum) | *read-write<br>(null)* | The current operating mode of the control. *For the possible property values, see ControlMode in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DefaultSetPoint** *(v1.3+)* | number | *read-only<br>(null)* | The default set point of the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PendingSetPoint** *(v1.6+)* | number | *read-only<br>(null)* | A set point pending application to the control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The reading of the sensor associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReadingUnits** | string | *read-only<br>(null)* | The units of the sensor reading associated with this control. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SetPoint** | number | *read-write<br>(null)* | The desired set point of the control. |
| } |   |   |
| **PowerLoadPercent** *(v1.1+)* { | object<br>(excerpt) |  | The power load (percent) for this device. This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| } |   |   |
| **PowerWatts** { | object<br>(excerpt) |  | Power consumption (W). This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ApparentVA** | number<br>(V.A) | *read-only<br>(null)* | The product of voltage and current for an AC circuit, in volt-ampere units. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PhaseAngleDegrees** *(v1.5+)* | number | *read-only<br>(null)* | The phase angle (degrees) between the current and voltage waveforms. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PowerFactor** | number | *read-only<br>(null)* | The power factor for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ReactiveVAR** | number<br>(V.A) | *read-only<br>(null)* | The square root of the difference term of squared apparent VA and squared power (Reading) for a circuit, in VAR units. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| } |   |   |
| **TemperatureCelsius** { | object<br>(excerpt) |  | Temperature (Celsius). This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| } |   |   |
| **Voltage** *(v1.4+)* { | object<br>(excerpt) |  | The voltage (V) for this device. This object is an excerpt of the *Sensor* resource located at the URI shown in DataSourceUri. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**CrestFactor** *(v1.1+)* | number | *read-only<br>(null)* | The crest factor for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataSourceUri** | string<br>(URI) | *read-only<br>(null)* | The link to the resource that provides the data for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-only<br>(null)* | The sensor value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**THDPercent** *(v1.1+)* | number<br>(%) | *read-only<br>(null)* | The total harmonic distortion percent (% THD). |
| } |   |   |

### Actions

#### ResetMetrics


**Description**


This action resets the summary metrics related to this equipment.


**Action URI**



*{Base URI of target resource}*/Actions/EnvironmentMetrics.ResetMetrics


**Action parameters**


This action takes no parameters.


#### ResetToDefaults *(v1.3+)*


**Description**


The action resets the values of writable properties to factory defaults.


**Action URI**



*{Base URI of target resource}*/Actions/EnvironmentMetrics.ResetToDefaults


**Action parameters**


This action takes no parameters.


### Property details

#### ControlMode

The current operating mode of the control.

| string | Description |
| :--- | :------------ |
| Automatic | Automatically adjust control to meet the set point. |
| Disabled | The control has been disabled. |
| Manual | No automatic adjustments are made to the control. |
| Override | User override of the automatic set point value. |

#### PhysicalContext

The area or device to which this sensor measurement applies.

| string | Description |
| :--- | :------------ |
| Accelerator | An accelerator. |
| ACInput | An AC input. |
| ACMaintenanceBypassInput | An AC maintenance bypass input. |
| ACOutput | An AC output. |
| ACStaticBypassInput | An AC static bypass input. |
| ACUtilityInput | An AC utility input. |
| ASIC | An ASIC device, such as a networking chip or chipset component. |
| Back | The back of the chassis. |
| Backplane | A backplane within the chassis. |
| Battery | A battery. |
| Board | A circuit board. |
| Chassis | The entire chassis. |
| ComputeBay | Within a compute bay. |
| CoolingSubsystem | The entire cooling, or air and liquid, subsystem. |
| CPU | A processor (CPU). |
| CPUSubsystem | The entire processor (CPU) subsystem. |
| DCBus | A DC bus. |
| Exhaust | The air exhaust point or points or region of the chassis. |
| ExpansionBay | Within an expansion bay. |
| Fan | A fan. |
| Filter | A filter. |
| FPGA | An FPGA. |
| Front | The front of the chassis. |
| GPU | A graphics processor (GPU). |
| GPUSubsystem | The entire graphics processor (GPU) subsystem. |
| Intake | The air intake point or points or region of the chassis. |
| LiquidInlet | The liquid inlet point of the chassis. |
| LiquidOutlet | The liquid outlet point of the chassis. |
| Lower | The lower portion of the chassis. |
| Manager | A management controller, such as a BMC (baseboard management controller). |
| Memory | A memory device. |
| MemorySubsystem | The entire memory subsystem. |
| Motor | A motor. |
| NetworkBay | Within a networking bay. |
| NetworkingDevice | A networking device. |
| PowerSubsystem | The entire power subsystem. |
| PowerSupply | A power supply. |
| PowerSupplyBay | Within a power supply bay. |
| Pump | A pump. |
| Rectifier | A rectifier device. |
| Reservoir | A reservoir. |
| Room | The room. |
| StorageBay | Within a storage bay. |
| StorageDevice | A storage device. |
| Switch | A switch device. |
| SystemBoard | The system board (PCB). |
| Transceiver | A transceiver. |
| Transformer | A transformer. |
| TrustedModule | A trusted module. |
| Upper | The upper portion of the chassis. |
| VoltageRegulator | A voltage regulator device. |

#### PhysicalSubContext

The usage or location within a device to which this sensor measurement applies.

| string | Description |
| :--- | :------------ |
| Input | The input. |
| Output | The output. |

### Example response


```json
{
    "@odata.type": "#EnvironmentMetrics.v1_3_2.EnvironmentMetrics",
    "Name": "Processor Environment Metrics",
    "TemperatureCelsius": {
        "DataSourceUri": "/redfish/v1/Chassis/1U/Sensors/CPU1Temp",
        "Reading": 44
    },
    "PowerWatts": {
        "DataSourceUri": "/redfish/v1/Chassis/1U/Sensors/CPU1Power",
        "Reading": 12.87
    },
    "FanSpeedsPercent": [
        {
            "DataSourceUri": "/redfish/v1/Chassis/1U/Sensors/CPUFan1",
            "DeviceName": "CPU #1 Fan Speed",
            "Reading": 80
        }
    ],
    "@odata.id": "/redfish/v1/Systems/437XR1138R2/Processors/1/EnvironmentMetrics"
}
```



## Job 1.3.0

|     |     |     |     |     |
| :--- | :--- | :--- | :--- | :--- |
| **Version** | *v1.3* | *v1.2* | *v1.1* | *v1.0* |
| **Release** | 2024.2 | 2022.3 | 2022.1 | 2018.2 |

### Description

The `Job` schema contains information about a job that a Redfish job service schedules or executes.  Clients create jobs to describe a series of operations that occur at periodic intervals.

### URIs

/&#8203;redfish/&#8203;v1/&#8203;JobService/&#8203;Jobs/&#8203;*{JobId}*<br>
/&#8203;redfish/&#8203;v1/&#8203;JobService/&#8203;Jobs/&#8203;*{JobId}*/&#8203;Steps/&#8203;*{JobId2}*<br>


### Properties

|Property     |Type     |Attributes   |Notes     |
| :--- | :--- | :--- | :--------------------- |
| **CreatedBy** | string | *read-only* | The person or program that created this job entry. |
| **CreationTime** *(v1.3+)* | string<br>(date-time) | *read-only* | The date and time when the job was created. |
| **EndTime** | string<br>(date-time) | *read-only* | The date and time when the job was completed. |
| **EstimatedCompletionTime** *(v1.3+)* | string<br>(date-time) | *read-only* | The date and time when the job is expected to complete. |
| **EstimatedDuration** *(v1.1+)* | string<br>(duration) | *read-only<br>(null)* | The estimated total time required to complete the job. |
| **HidePayload** | boolean | *read-only* | An indication of whether the contents of the payload should be hidden from view after the job has been created.  If `true`, responses do not return the payload.  If `false`, responses return the payload.  If this property is not present when the job is created, the default is `false`. |
| **JobPriority** *(v1.3+)* | integer | *read-only<br>(null)* | The requested priority for this job. |
| **JobState** | string<br>(enum) | *read-write* | The state of the job. *For the possible property values, see JobState in Property details.* |
| **JobStatus** | string<br>(enum) | *read-only* | The status of the job. *For the possible property values, see JobStatus in Property details.* |
| **JobType** *(v1.3+)* | string<br>(enum) | *read-only* | The type of this job. *For the possible property values, see JobType in Property details.* |
| **Links** *(v1.2+)* { | object |  | The links to other resources that are related to this resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**CreatedResources** *(v1.2+)* [ { | array |  | An array of URIs referencing the resources created as the result of this job. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string<br>(URI) | *read-only* | The unique identifier for a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**CreatedResources@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Executor** *(v1.3+)* { | object | *<br>(null)* | A link to the executor that is running this job. See the *JobExecutor* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a JobExecutor resource. See the Links section and the *JobExecutor* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**JobDocument** *(v1.3+)* { | object | *<br>(null)* | For Document-based jobs, this URI references the JobDocument resource that used when submitting this job. See the *JobDocument* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a JobDocument resource. See the Links section and the *JobDocument* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Oem** {} | object |  | The OEM extension property. See the *Resource* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ParentJob** *(v1.3+)* { | object | *<br>(null)* | The link to the job that created this job. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to another Job resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PreferredExecutors** *(v1.3+)* [ { | array |  | An array of links to the preferred executors to run this job. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a JobExecutor resource. See the Links section and the *JobExecutor* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PreferredExecutors@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SubsidiaryJobs** *(v1.3+)* [ { | array |  | An array of links to the jobs created by this job. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to another Job resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SubsidiaryJobs@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ValidatedExecutors** *(v1.3+)* [ { | array |  | An array of links to the executors that have been validated to run this job. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a JobExecutor resource. See the Links section and the *JobExecutor* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ValidatedExecutors@odata.count** | integer | *read-only* | The number of items in a collection. |
| } |   |   |
| **MaxExecutionTime** | string<br>(duration) | *read-write<br>(null)* | The maximum amount of time the job is allowed to execute. |
| **Messages** [ { } ] | array (object) |  | An array of messages associated with the job. See the *Message* schema for details on this property. |
| **Parameters** *(v1.3+)* { | object |  | The parameters specified for running this job. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**(pattern)** | string, boolean, number | *read-write<br>(null)* | Property names follow regular expression pattern "^\[A\-Za\-z\]\[A\-Za\-z0\-9\_\]\+$" |
| } |   |   |
| **Payload** { | object |  | The HTTP and JSON request payload details for this job. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HttpHeaders** [ ] | array (string) | *read-only* | An array of HTTP headers in this job. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HttpOperation** | string | *read-only* | The HTTP operation that executes this job. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**JsonBody** | string | *read-only* | The JSON payload to use in the execution of this job. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**TargetUri** | string<br>(URI) | *read-only* | The link to the target for this job. |
| } |   |   |
| **PercentComplete** | integer<br>(%) | *read-only<br>(null)* | The completion percentage of this job. |
| **Schedule** {} | object |  | The schedule settings for this job. See the *Schedule* schema for details on this property. |
| **StartTime** | string<br>(date-time) | *read-only* | The date and time when the job was started or is scheduled to start. |
| **StepOrder** [ ] | array (string) | *read-only* | The serialized execution order of the job steps. |
| **Steps** { | object |  | The link to a collection of steps for this job. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Job*. See the Job schema for details. |
| } |   |   |

### Actions

#### Cancel *(v1.3+)*


**Description**


Cancels the job.


**Action URI**



*{Base URI of target resource}*/Actions/Job.Cancel


**Action parameters**


This action takes no parameters.


#### ForceStart *(v1.3+)*


**Description**


Forces the job to start.


**Action URI**



*{Base URI of target resource}*/Actions/Job.ForceStart


**Action parameters**


This action takes no parameters.


#### Invalidate *(v1.3+)*


**Description**


Invalidates the job.


**Action URI**



*{Base URI of target resource}*/Actions/Job.Invalidate


**Action parameters**


This action takes no parameters.


#### Resubmit *(v1.3+)*


**Description**


Resubmits the job.


**Action URI**



*{Base URI of target resource}*/Actions/Job.Resubmit


**Action parameters**

| Parameter Name     | Type     | Attributes   | Notes     |
| :--- | :--- | :--- | :--------------------- |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**StartTime** | string<br>(date-time) | *optional* | The time to start the job. |

**Request Example**

```json
{
    "StartTime": "2022-01-16T04:14:33+06:00"
}
```



#### Resume *(v1.3+)*


**Description**


Resumes the job.


**Action URI**



*{Base URI of target resource}*/Actions/Job.Resume


**Action parameters**


This action takes no parameters.


#### Suspend *(v1.3+)*


**Description**


Suspends the job.


**Action URI**



*{Base URI of target resource}*/Actions/Job.Suspend


**Action parameters**


This action takes no parameters.


#### Validate *(v1.3+)*


**Description**


Validates the job.


**Action URI**



*{Base URI of target resource}*/Actions/Job.Validate


**Action parameters**


This action takes no parameters.


### Property details

#### JobState

The state of the job.

| string | Description |
| :--- | :------------ |
| Cancelled | Job was cancelled. |
| Completed | Job was completed. |
| Continue | Job is to resume operation. |
| Exception | Job has stopped due to an exception condition. |
| Interrupted | Job has been interrupted. |
| Invalid *(v1.3+)* | Job is invalid. |
| New | A new job. |
| Pending | Job is pending and has not started. |
| Running | Job is running normally. |
| Service | Job is running as a service. |
| Starting | Job is starting. |
| Stopping | Job is in the process of stopping. |
| Suspended | Job has been suspended. |
| UserIntervention | Job is waiting for user intervention. |
| Validating *(v1.3+)* | Job is validating. |

#### JobStatus

The status of the job.

| string | Description |
| :--- | :------------ |
| Critical | A critical condition requires immediate attention. |
| OK | Normal. |
| Warning | A condition requires attention. |

#### JobType

The type of this job.

| string | Description |
| :--- | :------------ |
| DocumentBased | A document-based job. |
| ServiceGenerated | A service-generated job. |
| UserSpecified | A user-specified job. |

### Example response


```json
{
    "@odata.type": "#Job.v1_2_4.Job",
    "Id": "RebootRack",
    "Name": "Scheduled Nightly Reboot of the rack",
    "JobStatus": "OK",
    "JobState": "Running",
    "StartTime": "2018-04-01T00:01+6:00",
    "PercentComplete": 24,
    "Schedule": {
        "Lifetime": "P4Y",
        "InitialStartTime": "2018-01-01T01:00:00+06:00",
        "RecurrenceInterval": "P1D",
        "EnabledDaysOfWeek": [
            "Monday",
            "Tuesday",
            "Wednesday",
            "Thursday",
            "Friday"
        ]
    },
    "Steps": {
        "@odata.id": "/redfish/v1/JobService/Jobs/RebootRack/Steps"
    },
    "StepOrder": [
        "Red",
        "Orange",
        "Yellow",
        "Green",
        "Blue",
        "Indigo",
        "Violet"
    ],
    "@odata.id": "/redfish/v1/JobService/Jobs/RebootRack"
}
```



## JobDocument 1.0.0

|     |     |
| :--- | :--- |
| **Version** | *v1.0* |
| **Release** | 2024.2 |

### Description

The `JobDocument` schema describes the template for a job with a set of parameters.

### URIs

/&#8203;redfish/&#8203;v1/&#8203;JobService/&#8203;Documents/&#8203;*{JobDocumentId}*<br>


### Properties

|Property     |Type     |Attributes   |Notes     |
| :--- | :--- | :--- | :--------------------- |
| **CreationTime** | string | *read-only* | The date and time when this job document resource was created. |
| **DocumentData** | string | *read-only* | The job document data as a Base64-encoded string. |
| **DocumentDataHash** | string | *read-only* | The hash of the job document data. |
| **DocumentDataURI** | string<br>(URI) | *read-only* | The URI at which to access the job document data. |
| **DocumentType** | string | *read-only* | The type of job document data associated with this job document. |
| **Links** { | object |  | The links to other resources that are related to this resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SupportedExecutors** [ { | array |  | An array of links to the executors that are capable of running jobs instantiated from this job document. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a JobExecutor resource. See the Links section and the *JobExecutor* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SupportedExecutors@odata.count** | integer | *read-only* | The number of items in a collection. |
| } |   |   |
| **ParameterMetadata** [ { | array |  | The metadata for each of the parameters supported by this job document for the `SubmitJob` action. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableNumbers** [ ] | array (string) | *read-only* | The allowable numeric values or duration values, inclusive ranges of values, and incremental step values for this parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowablePattern** | string | *read-only* | The allowable pattern for this parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableValueDescriptions** [ ] | array (string) | *read-only* | Descriptions of allowable values for this parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AllowableValues** [ ] | array (string) | *read-only* | The allowable values for this parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DataType** | string<br>(enum) | *read-only required* | The JSON property type for this parameter. *For the possible property values, see DataType in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Description** | string | *read-only* | A description of the parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**MaximumValue** | number | *read-only* | The maximum supported value for this parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**MinimumValue** | number | *read-only* | The minimum supported value for this parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Name** | string | *read-only required* | The name of the parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Required** | boolean | *read-only* | An indication of whether the parameter is required. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ValueHint** | string | *read-only* | A hint value for the parameter. |
| } ] |   |   |
| **Status** {} | object |  | The status and health of the resource and its subordinate or dependent resources. See the *Resource* schema for details on this property. |
| **Version** | string | *read-only* | The version of this job document. |

### Actions

#### SubmitJob


**Description**


Creates a new job based on the contents of this job document and additional parameters.


**Action URI**



*{Base URI of target resource}*/Actions/JobDocument.SubmitJob


**Action parameters**

| Parameter Name     | Type     | Attributes   | Notes     |
| :--- | :--- | :--- | :--------------------- |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HidePayload** | boolean | *optional* | An indication of whether the contents of the payload should be hidden from view after the job has been created.  If `true`, responses do not return the payload.  If `false`, responses return the payload.  If this parameter is not present when the job is created, the default is `false`. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**JobCreator** { | object | *optional* | The link to the job that is submitting this job. See the *Job* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a Job resource. See the Links section and the *Job* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Parameters** {} | object | *required* | The list of parameters for the new job that are specific to this job document. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**PreferredExecutors** [ { | array | *required* | An array of links to the preferred executors to run this job. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a JobExecutor resource. See the Links section and the *JobExecutor* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**StartTime** | string<br>(date-time) | *optional* | The date and time when the job is scheduled to start. |

**Request Example**

```json
{
    "JobCreator": {
        "@odata.id": "https://192.168.0.1/redfish/v1/JobService/Jobs/1"
    },
    "Parameters": {
        "AmountPieces": 10000,
        "Flavor": "Orange",
        "Shape": "Cylinder"
    },
    "StartTime": "2022-01-16T04:14:33+06:00",
    "PreferredExecutors": [
        {
            "@odata.id": "/redfish/v1/JobService/Executors/1"
        }
    ]
}
```



### Property details

#### DataType

The JSON property type for this parameter.

| string | Description |
| :--- | :------------ |
| Boolean | A boolean. |
| Number | A number. |
| String | A string. |

### Example response


```json
{
    "@odata.type": "#JobDocument.v1_0_0.JobDocument",
    "Id": "Recipe1",
    "Name": "Sweet candy",
    "Description" : "Produce specified amount of the sweet candies",
    "Actions": {
        "#JobDocument.SubmitJob": {
            "target": "/redfish/v1/JobService/Documents/Recipe1/Actions/JobDocument.SubmitJob"
        }
    },
    "DocumentType" : "Script",
    "Version" : "1.0.0-20210215",
    "CreationTime" : "2022-01-16T04:14:33+06:00",
    "DocumentDataURI" : "https://recipestore.vendor.com/recipes?Action=Download&RecipeId=SweetCandy",
    "Status": {
        "State": "Enabled",
        "Health": "OK"
    },
    "ParameterMetadata": [
        { 
            "Name" : "AmountPieces",
            "DataType" : "Number",
            "MinimumValue": 0,
            "Required": true,
            "Description": "The number of pieces to produce",
            "ValueHint": "10000"
        },
        { 
            "Name": "Flavors",
            "AllowableValues": ["Orange","Strawberry","Lemon","Lime","Raspberry","Vanilla"],
            "DataType": "String",
            "Required": true,
            "Description": "The flavors of the candy.  One or two choices may be given",
            "ValueHint": "Orange"
        },
        { 
            "Name":"Shape",
            "AllowableValues": ["Cylinder","Sphere","Dome","Cone"],
            "DataType" : "String",
            "Required": true,
            "Description": "The shape of the candy.",
            "ValueHint": "Dome"
        }
    ],
    "Links" : {
        "SupportedExecutors": [{"@odata.id":"/redfish/v1/JobService/Executors/1"}]
    },
    "@odata.id": "/redfish/v1/JobService/Documents/Recipe1"
}
```



## JobExecutor 1.0.0

|     |     |
| :--- | :--- |
| **Version** | *v1.0* |
| **Release** | 2024.2 |

### Description

The `JobExecutor` schema describes an entity that carries out a job.

### URIs

/&#8203;redfish/&#8203;v1/&#8203;JobService/&#8203;Executors/&#8203;*{JobExecutorId}*<br>


### Properties

|Property     |Type     |Attributes   |Notes     |
| :--- | :--- | :--- | :--------------------- |
| **ExecutorName** | string | *read-only* | The primary type of job this executor processes. |
| **Links** { | object |  | The links to other resources that are related to this resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Chassis** [ { | array |  | An array of links to the chassis that contain this equipment. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a Chassis resource. See the Links section and the *Chassis* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Chassis@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ComputerSystem** {} | object |  | The system that is performing the work of this job executor. See the *ComputerSystem* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ExecutingJobs** [ { | array |  | Links to jobs this executor is running. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a Job resource. See the Links section and the *Job* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ExecutingJobs@odata.count** | integer | *read-only* | The number of items in a collection. |
| } |   |   |
| **MaximumConcurrentJobs** | integer | *read-only* | The maximum concurrent jobs this executor can process. |
| **Status** {} | object |  | The status and health of the resource and its subordinate or dependent resources. See the *Resource* schema for details on this property. |
### Example response


```json
{
    "@odata.type": "#JobExecutor.v1_0_0.JobExecutor",
    "Id": "1",
    "Name": "Main Job Executor",
    "Description": "Executor for Document-based Jobs",
    "ExecutorName": "Script",
    "Status": {
        "State": "Enabled",
        "Health": "OK"
    },
    "MaximumConcurrentJobs": 1,
    "Links": {
        "ExecutingJobs": [
            {
                "@odata.id": "/redfish/v1/JobService/Jobs/1"
            }
        ],
        "Chassis": [{
            "@odata.id": "/redfish/v1/Chassis/Aggregator"
        }],
        "ComputerSystem": {
            "@odata.id": "/redfish/v1/Systems/1"
        }
    },
    "@odata.id": "/redfish/v1/JobService/Executors/1"
}
```



## JobService 1.1.0

|     |     |     |
| :--- | :--- | :--- |
| **Version** | *v1.1* | *v1.0* |
| **Release** | 2024.2 | 2018.2 |

### Description

The `JobService` schema contains properties for scheduling and execution of operations, represents the properties for the job service itself, and has links to jobs managed by the job service.

### URIs

/&#8203;redfish/&#8203;v1/&#8203;JobService<br>


### Properties

|Property     |Type     |Attributes   |Notes     |
| :--- | :--- | :--- | :--------------------- |
| **DateTime** | string<br>(date-time) | *read-only<br>(null)* | The current date and time setting for the job service. |
| **JobDocuments** *(v1.1+)* { | object |  | The links to the job document collection. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *JobDocument*. See the JobDocument schema for details. |
| } |   |   |
| **JobExecutors** *(v1.1+)* { | object |  | The links to the job executor collection. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *JobExecutor*. See the JobExecutor schema for details. |
| } |   |   |
| **Jobs** { | object |  | The links to the jobs collection. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Job*. See the Job schema for details. |
| } |   |   |
| **Log** {} | object |  | The link to a log service that the job service uses.  This service can be a dedicated log service or a pointer to a log service under another resource, such as a manager. See the *LogService* schema for details on this property. |
| **ServiceCapabilities** { | object |  | The supported capabilities of this job service implementation. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DocumentBasedJobs** *(v1.1+)* | boolean | *read-only<br>(null)* | An indication of whether document-based jobs are supported. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**MaxJobs** | integer | *read-only<br>(null)* | The maximum number of jobs supported. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**MaxSteps** | integer | *read-only<br>(null)* | The maximum number of job steps supported. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Scheduling** | boolean | *read-only<br>(null)* | An indication of whether scheduling of jobs is supported. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**UserSpecifiedJobs** *(v1.1+)* | boolean | *read-only<br>(null)* | An indication of whether user-specified jobs are supported. |
| } |   |   |
| **ServiceEnabled** | boolean | *read-write<br>(null)* | An indication of whether this service is enabled. |
| **Status** {} | object |  | The status and health of the resource and its subordinate or dependent resources. See the *Resource* schema for details on this property. |
| **ValidationPolicy** *(v1.1+)* | string<br>(enum) | *read-only<br>(null)* | The policy for how document-based jobs are validated. *For the possible property values, see ValidationPolicy in Property details.* |

### Actions

#### CancelAllJobs *(v1.1+)*


**Description**


Cancels all jobs.


**Action URI**



*{Base URI of target resource}*/Actions/JobService.CancelAllJobs


**Action parameters**


This action takes no parameters.


#### InvalidateAllJobs *(v1.1+)*


**Description**


Invalidates all jobs.


**Action URI**



*{Base URI of target resource}*/Actions/JobService.InvalidateAllJobs


**Action parameters**


This action takes no parameters.


#### SuspendAllJobs *(v1.1+)*


**Description**


Suspends all jobs.


**Action URI**



*{Base URI of target resource}*/Actions/JobService.SuspendAllJobs


**Action parameters**


This action takes no parameters.


### Property details

#### ValidationPolicy

The policy for how document-based jobs are validated.

| string | Description |
| :--- | :------------ |
| Automatic | Jobs are validated automatically. |
| Bypass | Jobs are not validated. |
| Manual | Jobs are validated manually. |

### Example response


```json
{
    "@odata.type": "#JobService.v1_0_6.JobService",
    "Id": "JobService",
    "Name": "Job Service",
    "DateTime": "2018-06-13T04:14+06:00",
    "Status": {
        "State": "Enabled",
        "Health": "OK"
    },
    "ServiceEnabled": true,
    "ServiceCapabilities": {
        "MaxJobs": 100,
        "MaxSteps": 50,
        "Scheduling": true
    },
    "Jobs": {
        "@odata.id": "/redfish/v1/JobService/Jobs"
    },
    "Log": {
        "@odata.id": "/redfish/v1/JobService/Log"
    },
    "Actions": {
        "Oem": {
            "#Contoso.EasyButton": {
                "target": "/redfish/v1/JobService/Contoso.EasyButton",
                "@Redfish.ActionInfo": "/redfish/v1/JobService/EasyButtonActionInfo"
            }
        }
    },
    "@odata.id": "/redfish/v1/JobService"
}
```



## Sensor 1.10.0

|     |     |     |     |     |     |     |     |     |     |     |     |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| **Version** | *v1.10* | *v1.9* | *v1.8* | *v1.7* | *v1.6* | *v1.5* | *v1.4* | *v1.3* | *v1.2* | *v1.1* | *v1.0* |
| **Release** | 2024.2 | 2024.1 | 2023.2 | 2023.1 | 2022.2 | 2021.4 | 2021.2 | 2021.1 | 2020.4 | 2019.4 | 2018.3 |

### Description

The `Sensor` schema describes a sensor and its properties.

### URIs

/&#8203;redfish/&#8203;v1/&#8203;Chassis/&#8203;*{ChassisId}*/&#8203;Sensors/&#8203;*{SensorId}*<br>
/&#8203;redfish/&#8203;v1/&#8203;PowerEquipment/&#8203;FloorPDUs/&#8203;*{PowerDistributionId}*/&#8203;Sensors/&#8203;*{SensorId}* (deprecated)<br>
/&#8203;redfish/&#8203;v1/&#8203;PowerEquipment/&#8203;PowerShelves/&#8203;*{PowerDistributionId}*/&#8203;Sensors/&#8203;*{SensorId}* (deprecated)<br>
/&#8203;redfish/&#8203;v1/&#8203;PowerEquipment/&#8203;RackPDUs/&#8203;*{PowerDistributionId}*/&#8203;Sensors/&#8203;*{SensorId}* (deprecated)<br>
/&#8203;redfish/&#8203;v1/&#8203;PowerEquipment/&#8203;Switchgear/&#8203;*{PowerDistributionId}*/&#8203;Sensors/&#8203;*{SensorId}* (deprecated)<br>
/&#8203;redfish/&#8203;v1/&#8203;PowerEquipment/&#8203;TransferSwitches/&#8203;*{PowerDistributionId}*/&#8203;Sensors/&#8203;*{SensorId}* (deprecated)<br>


### Properties

|Property     |Type     |Attributes   |Notes     |
| :--- | :--- | :--- | :--------------------- |
| **Accuracy** *(deprecated v1.8)* | number<br>(%) | *read-only<br>(null)* | The estimated percent error of measured versus actual values. *Deprecated in v1.8 and later. This property has been deprecated in favor of ReadingAccuracy.* |
| **AdjustedMaxAllowableOperatingValue** | number | *read-only<br>(null)* | The adjusted maximum allowable operating value for this equipment based on the environmental conditions. |
| **AdjustedMinAllowableOperatingValue** | number | *read-only<br>(null)* | The adjusted minimum allowable operating value for this equipment based on the environmental conditions. |
| **ApparentkVAh** *(v1.5+)* | number<br>(kV.A.h) | *read-only<br>(null)* | Apparent energy (kVAh). |
| **ApparentVA** | number<br>(V.A) | *read-only<br>(null)* | The product of voltage and current for an AC circuit, in volt-ampere units. |
| **AverageReading** *(v1.4+)* | number | *read-only<br>(null)* | The average sensor value. |
| **AveragingInterval** *(v1.4+)* | string<br>(duration) | *read-write<br>(null)* | The interval over which the average sensor value is calculated. |
| **AveragingIntervalAchieved** *(v1.4+)* | boolean | *read-only<br>(null)* | Indicates that enough readings were collected to calculate the average sensor reading over the averaging interval time. |
| **Calibration** *(v1.4+)* | number | *read-write<br>(null)* | The calibration offset applied to the Reading. |
| **CalibrationTime** *(v1.4+)* | string<br>(date-time) | *read-write<br>(null)* | The date and time that the sensor was last calibrated. |
| **CrestFactor** *(v1.1+)* | number | *read-only<br>(null)* | The crest factor for this sensor. |
| **ElectricalContext** | string<br>(enum) | *read-only<br>(null)* | The combination of current-carrying conductors. *For the possible property values, see ElectricalContext in Property details.* |
| **Enabled** *(v1.10+)* | boolean | *read-write<br>(null)* | Indicates whether the sensor is enabled and provides a reading. |
| **Implementation** *(v1.1+)* | string<br>(enum) | *read-only<br>(null)* | The implementation of the sensor. *For the possible property values, see Implementation in Property details.* |
| **LifetimeReading** *(v1.1+)* | number | *read-only<br>(null)* | The total accumulation value for this sensor. |
| **LifetimeStartDateTime** *(v1.9+)* | string<br>(date-time) | *read-only<br>(null)* | The date and time when the sensor started accumulating readings for the `LifetimeReading` property. |
| **Links** *(v1.3+)* { | object |  | The links to other resources that are related to this resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AssociatedControls** *(v1.4+)* [ { | array |  | An array of links to the controls that can affect this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a Control resource. See the Links section and the *Control* schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} ] |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**AssociatedControls@odata.count** | integer | *read-only* | The number of items in a collection. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Oem** {} | object |  | The OEM extension property. See the *Resource* schema for details on this property. |
| } |   |   |
| **LoadPercent** *(deprecated v1.1)* | number<br>(%) | *read-only<br>(null)* | The power load utilization for this sensor. *Deprecated in v1.1 and later. This property has been deprecated in favor of using a sensor instance with a `ReadingType` of `Percent` to show utilization values when needed.* |
| **Location** {} | object |  | The location information for this sensor. See the *Resource* schema for details on this property. |
| **LowestReading** *(v1.4+)* | number | *read-only<br>(null)* | The lowest sensor value. |
| **LowestReadingTime** *(v1.4+)* | string<br>(date-time) | *read-only<br>(null)* | The time when the lowest sensor value occurred. |
| **Manufacturer** *(v1.9+)* | string | *read-only<br>(null)* | The manufacturer of this sensor. |
| **MaxAllowableOperatingValue** | number | *read-only<br>(null)* | The maximum allowable operating value for this equipment. |
| **MinAllowableOperatingValue** | number | *read-only<br>(null)* | The minimum allowable operating value for this equipment. |
| **Model** *(v1.9+)* | string | *read-only<br>(null)* | The model number of the sensor. |
| **PartNumber** *(v1.9+)* | string | *read-only<br>(null)* | The part number of the sensor. |
| **PeakReading** | number | *read-only<br>(null)* | The peak sensor value. |
| **PeakReadingTime** | string<br>(date-time) | *read-only<br>(null)* | The time when the peak sensor value occurred. |
| **PhaseAngleDegrees** *(v1.5+)* | number | *read-only<br>(null)* | The phase angle (degrees) between the current and voltage waveforms. |
| **PhysicalContext** | string<br>(enum) | *read-write<br>(null)* | The area or device to which this sensor measurement applies. *For the possible property values, see PhysicalContext in Property details.* |
| **PhysicalSubContext** | string<br>(enum) | *read-write<br>(null)* | The usage or location within a device to which this sensor measurement applies. *For the possible property values, see PhysicalSubContext in Property details.* |
| **PowerFactor** | number | *read-only<br>(null)* | The power factor for this sensor. |
| **Precision** | number | *read-only<br>(null)* | The number of significant digits in the reading. |
| **ReactivekVARh** *(v1.5+)* | number<br>(kV.A.h) | *read-only<br>(null)* | Reactive energy (kVARh). |
| **ReactiveVAR** | number<br>(V.A) | *read-only<br>(null)* | The square root of the difference term of squared apparent VA and squared power (Reading) for a circuit, in VAR units. |
| **Reading** | number | *read-only<br>(null)* | The sensor value. |
| **ReadingAccuracy** *(v1.8+)* | number | *read-only<br>(null)* | Accuracy (+/-) of the reading. |
| **ReadingBasis** *(v1.7+)* | string<br>(enum) | *read-only<br>(null)* | The basis for the reading of this sensor. *For the possible property values, see ReadingBasis in Property details.* |
| **ReadingRangeMax** | number | *read-only<br>(null)* | The maximum possible value for this sensor. |
| **ReadingRangeMin** | number | *read-only<br>(null)* | The minimum possible value for this sensor. |
| **ReadingTime** *(v1.1+)* | string<br>(date-time) | *read-only<br>(null)* | The date and time that the reading was acquired from the sensor. |
| **ReadingType** | string<br>(enum) | *read-only<br>(null)* | The type of sensor. *For the possible property values, see ReadingType in Property details.* |
| **ReadingUnits** | string | *read-only<br>(null)* | The units of the reading and thresholds. |
| **RelatedItem** *(v1.2+)* [ { | array |  | An array of links to resources or objects that this sensor services. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string<br>(URI) | *read-only* | The unique identifier for a resource. |
| } ] |   |   |
| **SensingFrequency** *(deprecated v1.1)* | number | *read-only<br>(null)* | The time interval between readings of the physical sensor. *Deprecated in v1.1 and later. This property has been deprecated in favor of the `SensingInterval` property, which uses the duration time format for interoperability.* |
| **SensingInterval** *(v1.1+)* | string<br>(duration) | *read-only<br>(null)* | The time interval between readings of the sensor. |
| **SensorGroup** *(v1.4+)* {} | object |  | The group of sensors that provide readings for this sensor. See the *v1_4_2.v1_4_2* schema for details on this property. |
| **SensorResetTime** | string<br>(date-time) | *read-only<br>(null)* | The date and time when the time-based properties were last reset. |
| **SerialNumber** *(v1.9+)* | string | *read-only<br>(null)* | The serial number of the sensor. |
| **SKU** *(v1.9+)* | string | *read-only<br>(null)* | The SKU of the sensor. |
| **SparePartNumber** *(v1.9+)* | string | *read-only<br>(null)* | The spare part number of the sensor. |
| **SpeedRPM** *(v1.2+)* | number<br>({rev}/min) | *read-only<br>(null)* | The rotational speed. |
| **Status** {} | object |  | The status and health of the resource and its subordinate or dependent resources. See the *Resource* schema for details on this property. |
| **THDPercent** *(v1.1+)* | number<br>(%) | *read-only<br>(null)* | The total harmonic distortion percent (% THD). |
| **Thresholds** { | object |  | The set of thresholds defined for this sensor. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**LowerCaution** { | object |  | The value at which the reading is below normal range. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Activation** | string<br>(enum) | *read-write<br>(null)* | The direction of crossing that activates this threshold. *For the possible property values, see Activation in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DwellTime** | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must violate the threshold before the threshold is activated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisDuration** *(v1.7+)* | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must not violate the threshold before the threshold is deactivated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisReading** *(v1.7+)* | number | *read-write<br>(null)* | The reading offset from the threshold value required to clear the threshold. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-write<br>(null)* | The threshold value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**LowerCautionUser** *(v1.2+)* { | object |  | A user-defined value at which the reading is considered below normal range. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Activation** | string<br>(enum) | *read-write<br>(null)* | The direction of crossing that activates this threshold. *For the possible property values, see Activation in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DwellTime** | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must violate the threshold before the threshold is activated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisDuration** *(v1.7+)* | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must not violate the threshold before the threshold is deactivated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisReading** *(v1.7+)* | number | *read-write<br>(null)* | The reading offset from the threshold value required to clear the threshold. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-write<br>(null)* | The threshold value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**LowerCritical** { | object |  | The value at which the reading is below normal range but not yet fatal. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Activation** | string<br>(enum) | *read-write<br>(null)* | The direction of crossing that activates this threshold. *For the possible property values, see Activation in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DwellTime** | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must violate the threshold before the threshold is activated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisDuration** *(v1.7+)* | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must not violate the threshold before the threshold is deactivated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisReading** *(v1.7+)* | number | *read-write<br>(null)* | The reading offset from the threshold value required to clear the threshold. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-write<br>(null)* | The threshold value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**LowerCriticalUser** *(v1.2+)* { | object |  | A user-defined value at which the reading is considered below normal range but not yet fatal. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Activation** | string<br>(enum) | *read-write<br>(null)* | The direction of crossing that activates this threshold. *For the possible property values, see Activation in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DwellTime** | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must violate the threshold before the threshold is activated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisDuration** *(v1.7+)* | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must not violate the threshold before the threshold is deactivated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisReading** *(v1.7+)* | number | *read-write<br>(null)* | The reading offset from the threshold value required to clear the threshold. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-write<br>(null)* | The threshold value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**LowerFatal** { | object |  | The value at which the reading is below normal range and fatal. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Activation** | string<br>(enum) | *read-write<br>(null)* | The direction of crossing that activates this threshold. *For the possible property values, see Activation in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DwellTime** | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must violate the threshold before the threshold is activated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisDuration** *(v1.7+)* | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must not violate the threshold before the threshold is deactivated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisReading** *(v1.7+)* | number | *read-write<br>(null)* | The reading offset from the threshold value required to clear the threshold. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-write<br>(null)* | The threshold value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**UpperCaution** { | object |  | The value at which the reading is above normal range. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Activation** | string<br>(enum) | *read-write<br>(null)* | The direction of crossing that activates this threshold. *For the possible property values, see Activation in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DwellTime** | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must violate the threshold before the threshold is activated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisDuration** *(v1.7+)* | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must not violate the threshold before the threshold is deactivated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisReading** *(v1.7+)* | number | *read-write<br>(null)* | The reading offset from the threshold value required to clear the threshold. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-write<br>(null)* | The threshold value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**UpperCautionUser** *(v1.2+)* { | object |  | A user-defined value at which the reading is considered above normal range. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Activation** | string<br>(enum) | *read-write<br>(null)* | The direction of crossing that activates this threshold. *For the possible property values, see Activation in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DwellTime** | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must violate the threshold before the threshold is activated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisDuration** *(v1.7+)* | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must not violate the threshold before the threshold is deactivated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisReading** *(v1.7+)* | number | *read-write<br>(null)* | The reading offset from the threshold value required to clear the threshold. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-write<br>(null)* | The threshold value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**UpperCritical** { | object |  | The value at which the reading is above normal range but not yet fatal. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Activation** | string<br>(enum) | *read-write<br>(null)* | The direction of crossing that activates this threshold. *For the possible property values, see Activation in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DwellTime** | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must violate the threshold before the threshold is activated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisDuration** *(v1.7+)* | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must not violate the threshold before the threshold is deactivated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisReading** *(v1.7+)* | number | *read-write<br>(null)* | The reading offset from the threshold value required to clear the threshold. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-write<br>(null)* | The threshold value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**UpperCriticalUser** *(v1.2+)* { | object |  | A user-defined value at which the reading is considered above normal range but not yet fatal. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Activation** | string<br>(enum) | *read-write<br>(null)* | The direction of crossing that activates this threshold. *For the possible property values, see Activation in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DwellTime** | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must violate the threshold before the threshold is activated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisDuration** *(v1.7+)* | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must not violate the threshold before the threshold is deactivated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisReading** *(v1.7+)* | number | *read-write<br>(null)* | The reading offset from the threshold value required to clear the threshold. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-write<br>(null)* | The threshold value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**UpperFatal** { | object |  | The value at which the reading is above normal range and fatal. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Activation** | string<br>(enum) | *read-write<br>(null)* | The direction of crossing that activates this threshold. *For the possible property values, see Activation in Property details.* |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DwellTime** | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must violate the threshold before the threshold is activated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisDuration** *(v1.7+)* | string<br>(duration) | *read-write<br>(null)* | The duration the sensor value must not violate the threshold before the threshold is deactivated. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**HysteresisReading** *(v1.7+)* | number | *read-write<br>(null)* | The reading offset from the threshold value required to clear the threshold. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Reading** | number | *read-write<br>(null)* | The threshold value. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| } |   |   |
| **UserLabel** *(v1.9+)* | string | *read-write* | A user-assigned label. |
| **VoltageType** | string<br>(enum) | *read-only<br>(null)* | The voltage type for this sensor. *For the possible property values, see VoltageType in Property details.* |

### Actions

#### ResetMetrics


**Description**


Resets metrics related to this sensor.


**Action URI**



*{Base URI of target resource}*/Actions/Sensor.ResetMetrics


**Action parameters**


This action takes no parameters.


#### ResetToDefaults *(v1.6+)*


**Description**


The action resets the values of writable properties to factory defaults.


**Action URI**



*{Base URI of target resource}*/Actions/Sensor.ResetToDefaults


**Action parameters**


This action takes no parameters.


### Property details

#### Activation

The direction of crossing that activates this threshold.

| string | Description |
| :--- | :------------ |
| Decreasing | Value decreases below the threshold. |
| Disabled *(v1.7+)* | The threshold is disabled. |
| Either | Value crosses the threshold in either direction. |
| Increasing | Value increases above the threshold. |

#### ElectricalContext

The combination of current-carrying conductors.

| string | Description |
| :--- | :------------ |
| Line1 | The circuits that share the L1 current-carrying conductor. |
| Line1ToLine2 | The circuit formed by L1 and L2 current-carrying conductors. |
| Line1ToNeutral | The circuit formed by L1 and neutral current-carrying conductors. |
| Line1ToNeutralAndL1L2 | The circuit formed by L1, L2, and neutral current-carrying conductors. |
| Line2 | The circuits that share the L2 current-carrying conductor. |
| Line2ToLine3 | The circuit formed by L2 and L3 current-carrying conductors. |
| Line2ToNeutral | The circuit formed by L2 and neutral current-carrying conductors. |
| Line2ToNeutralAndL1L2 | The circuit formed by L1, L2, and Neutral current-carrying conductors. |
| Line2ToNeutralAndL2L3 | The circuits formed by L2, L3, and neutral current-carrying conductors. |
| Line3 | The circuits that share the L3 current-carrying conductor. |
| Line3ToLine1 | The circuit formed by L3 and L1 current-carrying conductors. |
| Line3ToNeutral | The circuit formed by L3 and neutral current-carrying conductors. |
| Line3ToNeutralAndL3L1 | The circuit formed by L3, L1, and neutral current-carrying conductors. |
| LineToLine | The circuit formed by two current-carrying conductors. |
| LineToNeutral | The circuit formed by a line and neutral current-carrying conductor. |
| Neutral | The grounded current-carrying return circuit of current-carrying conductors. |
| Total | The circuit formed by all current-carrying conductors. |

#### Implementation

The implementation of the sensor.

| string | Description |
| :--- | :------------ |
| PhysicalSensor | The reading is acquired from a physical sensor. |
| Reported | The reading is obtained from software or a device. |
| Synthesized | The reading is obtained by applying a calculation on one or more properties or multiple sensors.  The calculation is not provided. |

#### PhysicalContext

The area or device to which this sensor measurement applies.

| string | Description |
| :--- | :------------ |
| Accelerator | An accelerator. |
| ACInput | An AC input. |
| ACMaintenanceBypassInput | An AC maintenance bypass input. |
| ACOutput | An AC output. |
| ACStaticBypassInput | An AC static bypass input. |
| ACUtilityInput | An AC utility input. |
| ASIC | An ASIC device, such as a networking chip or chipset component. |
| Back | The back of the chassis. |
| Backplane | A backplane within the chassis. |
| Battery | A battery. |
| Board | A circuit board. |
| Chassis | The entire chassis. |
| ComputeBay | Within a compute bay. |
| CoolingSubsystem | The entire cooling, or air and liquid, subsystem. |
| CPU | A processor (CPU). |
| CPUSubsystem | The entire processor (CPU) subsystem. |
| DCBus | A DC bus. |
| Exhaust | The air exhaust point or points or region of the chassis. |
| ExpansionBay | Within an expansion bay. |
| Fan | A fan. |
| Filter | A filter. |
| FPGA | An FPGA. |
| Front | The front of the chassis. |
| GPU | A graphics processor (GPU). |
| GPUSubsystem | The entire graphics processor (GPU) subsystem. |
| Intake | The air intake point or points or region of the chassis. |
| LiquidInlet | The liquid inlet point of the chassis. |
| LiquidOutlet | The liquid outlet point of the chassis. |
| Lower | The lower portion of the chassis. |
| Manager | A management controller, such as a BMC (baseboard management controller). |
| Memory | A memory device. |
| MemorySubsystem | The entire memory subsystem. |
| Motor | A motor. |
| NetworkBay | Within a networking bay. |
| NetworkingDevice | A networking device. |
| PowerSubsystem | The entire power subsystem. |
| PowerSupply | A power supply. |
| PowerSupplyBay | Within a power supply bay. |
| Pump | A pump. |
| Rectifier | A rectifier device. |
| Reservoir | A reservoir. |
| Room | The room. |
| StorageBay | Within a storage bay. |
| StorageDevice | A storage device. |
| Switch | A switch device. |
| SystemBoard | The system board (PCB). |
| Transceiver | A transceiver. |
| Transformer | A transformer. |
| TrustedModule | A trusted module. |
| Upper | The upper portion of the chassis. |
| VoltageRegulator | A voltage regulator device. |

#### PhysicalSubContext

The usage or location within a device to which this sensor measurement applies.

| string | Description |
| :--- | :------------ |
| Input | The input. |
| Output | The output. |

#### ReadingBasis

The basis for the reading of this sensor.

| string | Description |
| :--- | :------------ |
| Delta | A reading that reports the difference between two measurements. |
| Headroom | A reading that decreases as it approaches a defined reference point. |
| Zero | A zero-based reading. |

#### ReadingType

The type of sensor.

| string | Description |
| :--- | :------------ |
| AbsoluteHumidity *(v1.5+)* | Absolute humidity (g/m^3). |
| AirFlow *(deprecated v1.7)* | Air flow (cu ft/min). *Deprecated in v1.7 and later. This value has been deprecated in favor of `AirFlowCMM` for consistent use of SI units.* |
| AirFlowCMM *(v1.7+)* | Air flow (m^3/min). |
| Altitude | Altitude (m). |
| Barometric | Barometric pressure (mm). |
| ChargeAh *(v1.4+)* | Charge (Ah). |
| Current | Current (A). |
| EnergyJoules | Energy (J). |
| EnergykWh | Energy (kWh). |
| EnergyWh *(v1.4+)* | Energy (Wh). |
| Frequency | Frequency (Hz). |
| Heat *(v1.7+)* | Heat (kW). |
| Humidity | Relative humidity (percent). |
| LinearAcceleration *(v1.10+)* | Linear acceleration (m/s^2). |
| LinearPosition *(v1.10+)* | Linear position or distance (m). |
| LinearVelocity *(v1.10+)* | Linear velocity (m/s). |
| LiquidFlow *(deprecated v1.7)* | Liquid flow (L/s). *Deprecated in v1.7 and later. This value has been deprecated in favor of `LiquidFlowLPM` for consistency of units typically expected or reported by `Sensor` and `Control` resources.* |
| LiquidFlowLPM *(v1.7+)* | Liquid flow (L/min). |
| LiquidLevel | Liquid level (cm). |
| Percent *(v1.1+)* | Percent (%). |
| Power | Power (W). |
| Pressure *(deprecated v1.7)* | Pressure (Pa). *Deprecated in v1.7 and later. This value has been deprecated in favor of `PressurePa` or `PressurekPa` for consistency of units between `Sensor` and `Control` resources.* |
| PressurekPa *(v1.5+)* | Pressure (kPa). |
| PressurePa *(v1.7+)* | Pressure (Pa). |
| Rotational | Rotational (RPM). |
| RotationalAcceleration *(v1.10+)* | Rotational acceleration (rad/s^2). |
| RotationalPosition *(v1.10+)* | Rotational position (rad). |
| RotationalVelocity *(v1.10+)* | Rotational velocity (rad/s). |
| Temperature | Temperature (C). |
| Voltage | Voltage (VAC or VDC). |

#### VoltageType

The voltage type for this sensor.

| string | Description |
| :--- | :------------ |
| AC | Alternating current. |
| DC | Direct current. |

### Example response


```json
{
    "@odata.type": "#Sensor.v1_9_0.Sensor",
    "Id": "CabinetTemp",
    "Name": "Rack Temperature",
    "ReadingType": "Temperature",
    "ReadingTime": "2019-12-25T04:14:33+06:00",
    "Status": {
        "State": "Enabled",
        "Health": "OK"
    },
    "Reading": 31.6,
    "ReadingUnits": "C",
    "ReadingRangeMin": 0,
    "ReadingRangeMax": 70,
    "Accuracy": 0.25,
    "Precision": 1,
    "SensingInterval": "PT3S",
    "PhysicalContext": "Chassis",
    "Thresholds": {
        "UpperCritical": {
            "Reading": 40,
            "Activation": "Increasing"
        },
        "UpperCaution": {
            "Reading": 35,
            "Activation": "Increasing"
        },
        "LowerCaution": {
            "Reading": 10,
            "Activation": "Increasing"
        }
    },
    "@odata.id": "/redfish/v1/Chassis/1/Sensors/CabinetTemp"
}
```



## ServiceRoot 1.18.0

|     |     |     |     |     |     |     |     |     |     |     |     |     |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| **Version** | *v1.18* | *v1.17* | *v1.16* | *v1.15* | *v1.14* | *v1.13* | *v1.12* | *v1.11* | *v1.10* | *v1.9* | *v1.8* | *...* |
| **Release** | 2024.2 | 2024.1 | 2023.1 | 2022.3 | 2022.1 | 2021.4 | 2021.3 | 2021.2 | 2021.1 | 2020.3 | 2020.2 | ... |

### Description

The `ServiceRoot` schema describes the root of the Redfish service, located at the '/redfish/v1' URI.  All other resources accessible through the Redfish interface on this device are linked directly or indirectly from the service root.

### URIs

/&#8203;redfish/&#8203;v1<br>
/&#8203;redfish/&#8203;v1/&#8203;<br>


### Properties

|Property     |Type     |Attributes   |Notes     |
| :--- | :--- | :--- | :--------------------- |
| **AccountService** {} | object |  | The link to the account service. See the *AccountService* schema for details on this property. |
| **AggregationService** *(v1.8+)* {} | object |  | The link to the aggregation service. See the *AggregationService* schema for details on this property. |
| **AutomationNodes** *(v1.18+)* { | object |  | The link to a collection of automation nodes. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *AutomationNode*. See the AutomationNode schema for details. |
| } |   |   |
| **Cables** *(v1.11+)* { | object |  | The link to a collection of cables. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Cable*. See the Cable schema for details. |
| } |   |   |
| **CertificateService** *(v1.5+)* {} | object |  | The link to the certificate service. See the *CertificateService* schema for details on this property. |
| **Chassis** { | object |  | The link to a collection of chassis. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Chassis*. See the Chassis schema for details. |
| } |   |   |
| **ComponentIntegrity** *(v1.13+)* { | object |  | The link to a collection of component integrity information. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *ComponentIntegrity*. See the ComponentIntegrity schema for details. |
| } |   |   |
| **CompositionService** *(v1.2+)* {} | object |  | The link to the composition service. See the *CompositionService* schema for details on this property. |
| **EventService** {} | object |  | The link to the event service. See the *EventService* schema for details on this property. |
| **Fabrics** *(v1.1+)* { | object |  | The link to a collection of fabrics. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Fabric*. See the Fabric schema for details. |
| } |   |   |
| **Facilities** *(v1.6+)* { | object |  | The link to a collection of facilities. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Facility*. See the Facility schema for details. |
| } |   |   |
| **JobService** *(v1.4+)* { | object |  | The link to the job service. See the *JobService* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to a JobService resource. See the Links section and the *JobService* schema for details. |
| } |   |   |
| **JsonSchemas** { | object |  | The link to a collection of JSON Schema files. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *JsonSchemaFile*. See the JsonSchemaFile schema for details. |
| } |   |   |
| **KeyService** *(v1.11+)* {} | object |  | The link to the key service. See the *KeyService* schema for details on this property. |
| **LicenseService** *(v1.12+)* {} | object |  | The link to the license service. See the *LicenseService* schema for details on this property. |
| **Links** { | object | *required* | The links to other resources that are related to this resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ManagerProvidingService** *(v1.15+)* {} | object |  | The link to the manager that is providing this Redfish service. See the *Manager* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Oem** {} | object |  | The OEM extension property. See the *Resource* schema for details on this property. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Sessions** { | object | *required* | The link to a collection of sessions. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Session*. See the Session schema for details. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| } |   |   |
| **Managers** { | object |  | The link to a collection of managers. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Manager*. See the Manager schema for details. |
| } |   |   |
| **NVMeDomains** *(v1.10+)* { | object |  | The link to a collection of NVMe domains. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string<br>(URI) | *read-only* | The unique identifier for a resource. |
| } |   |   |
| **PowerEquipment** *(v1.6+)* {} | object |  | The link to a set of power equipment. See the *PowerEquipment* schema for details on this property. |
| **Product** *(v1.3+)* | string | *read-only<br>(null)* | The product associated with this Redfish service. |
| **ProtocolFeaturesSupported** *(v1.3+)* { | object |  | The information about protocol features that the service supports. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DeepOperations** *(v1.7+)* { | object |  | The information about deep operations that the service supports. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DeepPATCH** *(v1.7+)* | boolean | *read-only* | An indication of whether the service supports the deep `PATCH` operation. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**DeepPOST** *(v1.7+)* | boolean | *read-only* | An indication of whether the service supports the deep `POST` operation. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**MaxLevels** *(v1.7+)* | integer | *read-only* | The maximum levels of resources allowed in deep operations. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ExcerptQuery** *(v1.4+)* | boolean | *read-only* | An indication of whether the service supports the `excerpt` query parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ExpandQuery** *(v1.3+)* { | object |  | The information about the use of `$expand` in the service. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**ExpandAll** *(v1.3+)* | boolean | *read-only* | An indication of whether the service supports the asterisk (`*`) option of the `$expand` query parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Levels** *(v1.3+)* | boolean | *read-only* | An indication of whether the service supports the `$levels` option of the `$expand` query parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**Links** *(v1.3+)* | boolean | *read-only* | An indication of whether this service supports the tilde (`~`) option of the `$expand` query parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**MaxLevels** *(v1.3+)* | integer | *read-only* | The maximum `$levels` option value in the `$expand` query parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**NoLinks** *(v1.3+)* | boolean | *read-only* | An indication of whether the service supports the period (`.`) option of the `$expand` query parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;} |   |   |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**FilterQuery** *(v1.3+)* | boolean | *read-only* | An indication of whether the service supports the `$filter` query parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**FilterQueryComparisonOperations** *(v1.17+)* | boolean | *read-only* | An indication of whether the service supports the `eq`, `ge`, `gt`, `le`, `lt`, and `ne` options for the `$filter` query parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**FilterQueryCompoundOperations** *(v1.17+)* | boolean | *read-only* | An indication of whether the service supports the `()`, `and`, `not`, and `or` options for the `$filter` query parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**MultipleHTTPRequests** *(v1.14+)* | boolean | *read-only* | An indication of whether the service supports multiple outstanding HTTP requests. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**OnlyMemberQuery** *(v1.4+)* | boolean | *read-only* | An indication of whether the service supports the `only` query parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**SelectQuery** *(v1.3+)* | boolean | *read-only* | An indication of whether the service supports the `$select` query parameter. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**TopSkipQuery** *(v1.17+)* | boolean | *read-only* | An indication of whether the service supports both the `$top` and `$skip` query parameters. |
| } |   |   |
| **RedfishVersion** | string | *read-only* | The version of the Redfish service. |
| **RegisteredClients** *(v1.13+)* { | object |  | The link to a collection of registered clients. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *RegisteredClient*. See the RegisteredClient schema for details. |
| } |   |   |
| **Registries** { | object |  | The link to a collection of registries. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *MessageRegistryFile*. See the MessageRegistryFile schema for details. |
| } |   |   |
| **ResourceBlocks** *(v1.5+)* { | object |  | The link to a collection of resource blocks.  This collection is intended for implementations that do not contain a composition service but that expose resources to an orchestrator that implements a composition service. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *ResourceBlock*. See the ResourceBlock schema for details. |
| } |   |   |
| **ServiceConditions** *(v1.13+)* {} | object |  | The link to the service conditions. See the *ServiceConditions* schema for details on this property. |
| **ServiceIdentification** *(v1.14+)* | string | *read-only* | The vendor or user-provided product and service identifier. |
| **SessionService** {} | object |  | The link to the sessions service. See the *SessionService* schema for details on this property. |
| **Storage** *(v1.9+)* { | object |  | The link to a collection of storage subsystems. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *Storage*. See the Storage schema for details. |
| } |   |   |
| **StorageServices** *(v1.1+)* { | object |  | The link to a collection of storage services. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string<br>(URI) | *read-only* | The unique identifier for a resource. |
| } |   |   |
| **StorageSystems** *(v1.1+)* { | object |  | The link to a collection of storage systems. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string<br>(URI) | *read-only* | The unique identifier for a resource. |
| } |   |   |
| **Systems** { | object |  | The link to a collection of systems. Contains a link to a resource. |
| &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**@odata.id** | string | *read-only* | Link to Collection of *ComputerSystem*. See the ComputerSystem schema for details. |
| } |   |   |
| **Tasks** {} | object |  | The link to the task service. See the *TaskService* schema for details on this property. |
| **TelemetryService** *(v1.4+)* {} | object |  | The link to the telemetry service. See the *TelemetryService* schema for details on this property. |
| **ThermalEquipment** *(v1.16+)* {} | object |  | The link to a set of cooling equipment. See the *ThermalEquipment* schema for details on this property. |
| **UpdateService** *(v1.1+)* {} | object |  | The link to the update service. See the *UpdateService* schema for details on this property. |
| **UUID** | string<br>(uuid) | *read-only<br>(null)* | Unique identifier for a service instance.  When SSDP is used, this value contains the same UUID returned in an HTTP `200 OK` response from an SSDP `M-SEARCH` request during discovery. |
| **Vendor** *(v1.5+)* | string | *read-only<br>(null)* | The vendor or manufacturer associated with this Redfish service. |
### Example response


```json
{
    "@odata.type": "#ServiceRoot.v1_17_0.ServiceRoot",
    "Id": "RootService",
    "Name": "Root Service",
    "RedfishVersion": "1.15.0",
    "UUID": "92384634-2938-2342-8820-489239905423",
    "Product": "UR99 1U Server",
    "ProtocolFeaturesSupported": {
        "ExpandQuery": {
            "ExpandAll": true,
            "Levels": true,
            "MaxLevels": 6,
            "Links": true,
            "NoLinks": true
        },
        "SelectQuery": false,
        "FilterQuery": false,
        "OnlyMemberQuery": true,
        "ExcerptQuery": true,
        "MultipleHTTPRequests": true
    },
    "ServiceConditions": {
        "@odata.id": "/redfish/v1/ServiceConditions"
    },
    "Systems": {
        "@odata.id": "/redfish/v1/Systems"
    },
    "Chassis": {
        "@odata.id": "/redfish/v1/Chassis"
    },
    "Managers": {
        "@odata.id": "/redfish/v1/Managers"
    },
    "UpdateService": {
        "@odata.id": "/redfish/v1/UpdateService"
    },
    "CompositionService": {
        "@odata.id": "/redfish/v1/CompositionService"
    },
    "Tasks": {
        "@odata.id": "/redfish/v1/TaskService"
    },
    "SessionService": {
        "@odata.id": "/redfish/v1/SessionService"
    },
    "AccountService": {
        "@odata.id": "/redfish/v1/AccountService"
    },
    "EventService": {
        "@odata.id": "/redfish/v1/EventService"
    },
    "Links": {
        "Sessions": {
            "@odata.id": "/redfish/v1/SessionService/Sessions"
        }
    },
    "@odata.id": "/redfish/v1/"
}
```



# Redfish documentation generator

This document was created using the Redfish Documentation Generator utility, which uses the contents of the Redfish schema files (in JSON schema format) to automatically generate the bulk of the text.  The source code for the utility is available for download at the DMTF's Github repository located at <a href="http://www.github.com/DMTF/Redfish-Tools">http://www.github.com/DMTF/Redfish-Tools</a>.


