@setlocal
@echo off
rem #*******************************************************************************************************************
rem # DMTF - Distributed Management Task Force, Inc. - http://www.dmtf.org
rem # See dsp2023_readme.txt for copyright information.
rem #
rem # xalan.bat - part of the DMTF DSP2023 zip archive.
rem #
rem # Windows batch shell script that invokes the Apache Xalan-J XSLT processor.
rem #
rem # It passes all command line parameters through to Xalan-J, and adds the -URIRESOLVER parameter. For a list of
rem # Xalan-J command line parameters, see http://xml.apache.org/xalan-j/commandline.html.
rem #
rem # The -URIRESOLVER option causes XML Catalog processing to be turned on for URI references. It uses the settings in
rem # file CatalogManager.properties that is looked up in the Java CLASSPATH. It is recommended to place the
rem # CatalogManager.properties file into the URIRESOLVER_HOME directory.  
rem #*******************************************************************************************************************

rem Customize the following path to where Xalan-J has been installed:
set XALAN_HOME=C:\Apache\xalan-2.7.1

rem Customize the following path to where the Apache URI resolver (from XML-Commons) has been installed:
set URIRESOLVER_HOME=C:\Apache\xml-commons-resolver-1.2

set CLASSPATH=%XALAN_HOME%\xalan.jar;%XALAN_HOME%\serializer.jar;%XALAN_HOME%\xml-apis.jar;%XALAN_HOME%\xercesImpl.jar;%URIRESOLVER_HOME%\resolver.jar;%XALAN_HOME%;%URIRESOLVER_HOME%;%CLASSPATH%

java org.apache.xalan.xslt.Process -URIRESOLVER org.apache.xml.resolver.tools.CatalogResolver %* 2>&1
